//=============================================================================
// HoverTaxi.
//=============================================================================
class HoverTaxi extends TNMVehicles;

#exec mesh IMPORT MESH=HoverTaxi ANIVFILE=MODELS\HoverTaxi_a.3d DATAFILE=MODELS\HoverTaxi_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH ORIGIN MESH=HoverTaxi X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=HoverTaxi SEQ=All       STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=HoverTaxi SEQ=HoverTaxi STARTFRAME=0 NUMFRAMES=1

#exec texture IMPORT NAME=JHoverTaxi1 FILE=Textures\Vehicles\TaxiTex1.PCX GROUP=Skins // MATERIAL #2
#exec texture IMPORT NAME=JHoverTaxi2 FILE=Textures\Vehicles\TaxiTex2.PCX GROUP=Skins // MATERIAL #3
#exec texture IMPORT NAME=JHoverTaxi3 FILE=Textures\Vehicles\TaxiTex3.PCX GROUP=Skins // MATERIAL #4
#exec texture IMPORT NAME=JHoverTaxi4 FILE=Textures\Vehicles\CarBottomTex.PCX GROUP=Skins // MATERIAL #5

#exec MESHMAP NEW   MESHMAP=HoverTaxi MESH=HoverTaxi
#exec MESHMAP SCALE MESHMAP=HoverTaxi X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=HoverTaxi NUM=1 TEXTURE=JHoverTaxi1
#exec MESHMAP SETTEXTURE MESHMAP=HoverTaxi NUM=2 TEXTURE=JHoverTaxi2
#exec MESHMAP SETTEXTURE MESHMAP=HoverTaxi NUM=3 TEXTURE=JHoverTaxi3
#exec MESHMAP SETTEXTURE MESHMAP=HoverTaxi NUM=4 TEXTURE=JHoverTaxi4
#exec MESHMAP SETTEXTURE MESHMAP=HoverTaxi NUM=5 TEXTURE=Effects.electricity.Nano_SFX_A

defaultproperties
{
     ItemName="Hover Taxi"
     Mesh=LodMesh'TNMDeco.HoverTaxi'
     DrawScale=5.000000
     SoundRadius=160
     SoundVolume=192
     AmbientSound=Sound'DeusExSounds.Generic.ElectronicsHum'
     CollisionRadius=110.000000
     CollisionHeight=60.000000
     Mass=6000.000000
     Buoyancy=1000.000000
}
