//=============================================================================
// LightTube.
//=============================================================================
class LightTube extends TNMDecoration;

enum ESkinColor
{
	SC_Green,
	SC_BLue,
	SC_Red,
	SC_Yellow
};

var() ESkinColor SkinColor;

function BeginPlay()
{
	Super.BeginPlay();

	switch (SkinColor)
	{
		case SC_Green:	MultiSkins[1] = Texture'LightTubeTex2'; break;
		case SC_Blue:	MultiSkins[1] = Texture'LightTubeTex3'; break;
		case SC_Red:	MultiSkins[1] = Texture'LightTubeTex4'; break;
		case SC_Yellow:	MultiSkins[1] = Texture'LightTubeTex5'; break;
	}
}

#exec MESH IMPORT MESH=LightTube ANIVFILE=Models\LightTube_a.3d DATAFILE=Models\LightTube_d.3d
#exec MESH ORIGIN MESH=LightTube X=0 Y=0 Z=0
#exec MESHMAP SCALE MESHMAP=LightTube X=0.00390625 Y=0.00390625 Z=0.00390625
#exec MESH SEQUENCE MESH=LightTube SEQ=All	STARTFRAME=0	NUMFRAMES=1
#exec MESH SEQUENCE MESH=LightTube SEQ=Still	STARTFRAME=0	NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=LightTube MESH=LightTube

#exec TEXTURE IMPORT NAME=LightTubeTex1 FILE=Textures\LightTube_a.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=LightTubeTex2 FILE=Textures\LightTube_b.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=LightTubeTex3 FILE=Textures\LightTube_c.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=LightTubeTex4 FILE=Textures\LightTube_d.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=LightTubeTex5 FILE=Textures\LightTube_e.pcx GROUP="Skins"
#exec MESHMAP SETTEXTURE MESHMAP=LightTube NUM=0 TEXTURE=LightTubeTex1
#exec MESHMAP SETTEXTURE MESHMAP=LightTube NUM=1 TEXTURE=LightTubeTex2

defaultproperties
{
     HitPoints=5
     bInvincible=True
     bHighlight=False
     ItemName="Light Tube"
     bPushable=False
     Physics=PHYS_None
     Mesh=LodMesh'TNMDeco.LightTube'
     CollisionRadius=24.000000
     CollisionHeight=1.000000
     Mass=10.000000
     Buoyancy=15.000000
}
