//=============================================================================
// Magazine.
//=============================================================================
class Magazine extends tnmInformationDevices;

enum ESkinColor
{
	SC_TechToday,
	SC_Parallel,
	SC_INVEST,
	SC_ThePulse,
	SC_Arcadia,
	SC_PCGamer,
	SC_DXO
};

var() ESkinColor SkinColor;

function BeginPlay()
{
	Super.BeginPlay();

	switch (SkinColor)
	{
		case SC_TechToday:	Skin = Texture'Magazine_TechToday'; break;
		case SC_Parallel:	Skin = Texture'Magazine_Parallel'; break;
		case SC_INVEST:		Skin = Texture'Magazine_INVEST'; break;
		case SC_ThePulse:	Skin = Texture'Magazine_ThePulse'; break;
		case SC_Arcadia:	Skin = Texture'Magazine_Arcadia'; break;
		case SC_PCGamer:	Skin = Texture'Magazine_PCGamer'; break;
		case SC_DXO:		Skin = Texture'Magazine_DXO'; break;
	}
}


#exec MESH IMPORT MESH=Magazine ANIVFILE=Models\Magazine_a.3d DATAFILE=Models\Magazine_d.3d ZEROTEX=1
#exec MESH ORIGIN MESH=Magazine X=0 Y=0 Z=0
#exec MESHMAP SCALE MESHMAP=Magazine X=0.00390625 Y=0.00390625 Z=0.00390625
#exec MESH SEQUENCE MESH=Magazine SEQ=All	STARTFRAME=0	NUMFRAMES=1
#exec MESH SEQUENCE MESH=Magazine SEQ=Still     STARTFRAME=0	NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=Magazine MESH=Magazine


#exec TEXTURE IMPORT NAME=Magazine_TechToday FILE=Textures\Literature\Magazine_TechToday.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Magazine_Parallel FILE=Textures\Literature\Magazine_Parallel.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Magazine_INVEST FILE=Textures\Literature\Magazine_INVEST.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Magazine_ThePulse FILE=Textures\Literature\Magazine_ThePulse.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Magazine_Arcadia FILE=Textures\Literature\Magazine_Arcadia.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Magazine_PCGamer FILE=Textures\Literature\Magazine_PCGamer.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Magazine_DXO FILE=Textures\Literature\Magazine_DXO.pcx GROUP="Skins"


#exec MESHMAP SETTEXTURE MESHMAP=Magazine NUM=0 TEXTURE=Magazine_PCGamer

defaultproperties
{
     bCanBeBase=True
     ItemName="Magazine"
     Mesh=LodMesh'TNMDeco.Magazine'
     CollisionRadius=8.000000
     CollisionHeight=0.600000
     Mass=2.000000
     Buoyancy=4.000000
}
