//=============================================================================
// MagicBook.
//=============================================================================
class MagicBook extends tnm.tnmInformationDevices;

enum ESkinColor
{
	SC_TNMMagicBook1,
	SC_TNMMagicBook2

};

var() ESkinColor SkinColor;

function BeginPlay()
{
	Super.BeginPlay();

	switch (SkinColor)
	{
		case SC_TNMMagicBook1:	Skin = Texture'JTNMMagicBook1'; break;
		case SC_TNMMagicBook2:	Skin = Texture'JTNMMagicBook2'; break;
	}
}


#exec MESH IMPORT MESH=TNMMagicBook ANIVFILE=MODELS\TNMMagicBook_a.3d DATAFILE=MODELS\TNMMagicBook_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=TNMMagicBook X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=TNMMagicBook SEQ=All       STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=TNMMagicBook SEQ=MagicBook STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=JTNMMagicBook1 FILE=Textures\Literature\MagicBook1.PCX GROUP=Skins // 1 - Default
#exec TEXTURE IMPORT NAME=JTNMMagicBook2 FILE=Textures\Literature\MagicBook2.PCX GROUP=Skins // 1 - Default

#exec MESHMAP NEW   MESHMAP=TNMMagicBook MESH=TNMMagicBook
#exec MESHMAP SCALE MESHMAP=TNMMagicBook X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=TNMMagicBook NUM=1 TEXTURE=JTNMMagicBook1

defaultproperties
{
     FragType=Class'DeusEx.WoodFragment'
     ItemName="MagicBook"
     Mesh=LodMesh'TNMDeco.TNMMagicBook'
     CollisionRadius=40.000000
     CollisionHeight=5.000000
     Mass=25.000000
     Buoyancy=5.000000
}
