//=============================================================================
// MilitaryRadio.
//=============================================================================
class MilitaryRadio extends TNMDecoration;

var int FrobCount;

#exec mesh IMPORT MESH=MilitaryRadio ANIVFILE=MODELS\MilitaryRadio_a.3d DATAFILE=MODELS\MilitaryRadio_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH ORIGIN MESH=MilitaryRadio X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=MilitaryRadio SEQ=All      STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=MilitaryRadio SEQ=MilRadio STARTFRAME=0 NUMFRAMES=1

#exec texture IMPORT NAME=JMilitaryRadio1 FILE=Textures\MilRadioTex1.PCX GROUP=Skins // MATERIAL #25
#exec texture IMPORT NAME=JMilitaryRadio2 FILE=Textures\MilRadioTex2.PCX GROUP=Skins // MATERIAL #26

#exec MESHMAP NEW   MESHMAP=MilitaryRadio MESH=MilitaryRadio
#exec MESHMAP SCALE MESHMAP=MilitaryRadio X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=MilitaryRadio NUM=1 TEXTURE=JMilitaryRadio1
#exec MESHMAP SETTEXTURE MESHMAP=MilitaryRadio NUM=2 TEXTURE=JMilitaryRadio2

var localized string message1;
var localized string message2;
var localized string message3;
var localized string message4;
var localized string message5;

function Frob( Actor Frobber, Inventory frobWith )
{
	local DeusExPlayer DXP;

	Super.Frob( Frobber, frobWith );

	DXP = DeusExPlayer( Frobber );
	if ( DXP == None )
		return;

	FrobCount++;
	switch( FrobCount )
	{
		case 5:
			DXP.ClientMessage( message1 );
			break;
		case 6:
			DXP.ClientMessage( message2 );
			break;
		case 7:
			DXP.ClientMessage( message3 );
			break;
		case 8:
			DXP.ClientMessage( message4 );
			break;
		case 9:
			DXP.ClientMessage( message5 );
			break;
		default:
	}
}

defaultproperties
{
     message1="Nobody's listening."
     message2="Can't you just walk past a set of buttons without touching each one?"
     message3="This is NOT Morrowind!"
     message4="Or are you just that desperate to hear your own voice?"
     message5="Maybe you're hoping to catch a signal from outer space?"
     ItemName="Military Radio"
     Mesh=LodMesh'TNMDeco.MilitaryRadio'
     CollisionRadius=20.000000
     CollisionHeight=13.500000
     Mass=50.000000
     Buoyancy=100.000000
}
