//=============================================================================
// Mug.
//=============================================================================
class Mug extends TNMDecoration;

enum ESkinColor
{
	SC_NoName,
    SC_Ahmatron,
	SC_ddl,
	SC_fub,
	SC_grub,
	SC_jonas,
	SC_moonbo,
	SC_nvshacker,
	SC_zeropressence,
	SC_orak,
    SC_phasmatis,
    SC_ricemanu,
    SC_thatguy,
    SC_trestkon

};

var() ESkinColor SkinColor;

function BeginPlay()
{
	Super.BeginPlay();

	switch (SkinColor)
	{
		case SC_NoName:      	Texture = Texture'JMugTex1'; break;
        case SC_Ahmatron:	    Texture = Texture'JMugTex2'; break;
		case SC_ddl:	        Texture = Texture'JMugTex3'; break;
		case SC_fub:	        Texture = Texture'JMugTex4'; break;
		case SC_grub:	        Texture = Texture'JMugTex5'; break;
		case SC_jonas:	        Texture = Texture'JMugTex6'; break;
		case SC_moonbo:	        Texture = Texture'JMugTex7'; break;
		case SC_nvshacker:	    Texture = Texture'JMugTex8'; break;
		case SC_zeropressence:	Texture = Texture'JMugTex9'; break;
		case SC_orak:	        Texture = Texture'JMugTex10'; break;
		case SC_phasmatis:	    Texture = Texture'JMugTex11'; break;
		case SC_ricemanu:	    Texture = Texture'JMugTex12'; break;
		case SC_thatguy:	    Texture = Texture'JMugTex13'; break;
		case SC_trestkon:	    Texture = Texture'JMugTex13'; break;
	}
}

#exec MESH IMPORT MESH=Mug ANIVFILE=MODELS\Mug_a.3d DATAFILE=MODELS\Mug_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH ORIGIN MESH=Mug X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=Mug SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Mug SEQ=Mug STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=JMugTex1 FILE=Textures\OfficeMug\mugtex.pcx GROUP=Skins // 01 - default
#exec texture IMPORT NAME=JMugTex2 FILE=Textures\OfficeMug\mugahmatron.pcx GROUP=Skins
#exec texture IMPORT NAME=JMugTex3 FILE=Textures\OfficeMug\mugddl.pcx GROUP=Skins
#exec texture IMPORT NAME=JMugTex4 FILE=Textures\OfficeMug\mugfub.pcx GROUP=Skins
#exec texture IMPORT NAME=JMugTex5 FILE=Textures\OfficeMug\muggrub.pcx GROUP=Skins
#exec texture IMPORT NAME=JMugTex6 FILE=Textures\OfficeMug\mugjonas.pcx GROUP=Skins
#exec texture IMPORT NAME=JMugTex7 FILE=Textures\OfficeMug\mugmoonbo.pcx GROUP=Skins
#exec texture IMPORT NAME=JMugTex8 FILE=Textures\OfficeMug\mugnvshacker.pcx GROUP=Skins
#exec texture IMPORT NAME=JMugTex9 FILE=Textures\OfficeMug\mugzeropressence.pcx GROUP=Skins
#exec texture IMPORT NAME=JMugTex10 FILE=Textures\OfficeMug\mugorak.pcx GROUP=Skins
#exec texture IMPORT NAME=JMugTex11 FILE=Textures\OfficeMug\mugphasmatis.pcx GROUP=Skins
#exec texture IMPORT NAME=JMugTex12 FILE=Textures\OfficeMug\mugricemanu.pcx GROUP=Skins
#exec texture IMPORT NAME=JMugTex13 FILE=Textures\OfficeMug\mugthatguy.pcx GROUP=Skins
#exec texture IMPORT NAME=JMugTex14 FILE=Textures\OfficeMug\mugtrestkon.pcx GROUP=Skins

#exec MESHMAP new   MESHMAP=Mug MESH=Mug
#exec MESHMAP SCALE MESHMAP=Mug X=0.00390625 Y=0.00390625 Z=0.00390625

defaultproperties
{
     bHighlight=true
     ItemName="Coffee Mug"
     bPushable=true
     Mesh=LodMesh'Mug'
     Texture=Texture'JMugTex1'
     DrawScale=0.830000
     CollisionRadius=5.000000
     CollisionHeight=4.000000
     Mass=5.000000
     Buoyancy=3.000000
     FragType=Class'DeusEx.PlasticFragment'
     PushSound=Sound'DeusExSounds.Generic.PushPlastic'
}
