//=============================================================================
// NetworkPrinter.
//=============================================================================
class NetworkPrinter extends Printer;

function Timer()
{
	local DeusExPlayer player;
	local Vector loc;
	local TNMInformationDevices product;

    bUsing = False;
//	PlayAnim('Still');
	AmbientSound = None;
	loc = Vector(Rotation) * (CollisionRadius * 0.8 - 30);
	loc.Z = -class'NWPaper'.default.CollisionHeight + 37;
	loc += Location;

	product = Spawn(class'NWPaper', None,, loc);
	product.textTag[0] = printingTag;
	product.notetag = printingTag;
	numUses--;

	PlaysoundPrintEnd();
	PlaySoundPaperOutEnd();
}

#exec mesh IMPORT MESH=NetworkPrinter ANIVFILE=MODELS\NetworkPrinter_a.3d DATAFILE=MODELS\NetworkPrinter_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH ORIGIN MESH=NetworkPrinter X=0 Y=0 Z=0

#exec mesh SEQUENCE MESH=NetworkPrinter SEQ=All            STARTFRAME=0 NUMFRAMES=12
#exec mesh SEQUENCE MESH=NetworkPrinter SEQ=Still   STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=NetworkPrinter SEQ=Spool   STARTFRAME=0 NUMFRAMES=12  Rate=4
#exec mesh SEQUENCE MESH=NetworkPrinter SEQ=NoPaper STARTFRAME=0 NUMFRAMES=1  Rate=4

#exec texture IMPORT NAME=JNetworkPrinter1 FILE=Textures\networkprinter.pcx GROUP=Skins // ORIG_ORIG_01 - D
#exec texture IMPORT NAME=JNetworkPrinter2 FILE=Textures\networkprinterpaper.pcx GROUP=Skins // MATERIAL #147

#exec MESHMAP NEW   MESHMAP=NetworkPrinter MESH=NetworkPrinter
#exec MESHMAP SCALE MESHMAP=NetworkPrinter X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=NetworkPrinter NUM=1 TEXTURE=JNetworkPrinter1
#exec MESHMAP SETTEXTURE MESHMAP=NetworkPrinter NUM=2 TEXTURE=JNetworkPrinter2

defaultproperties
{
     numUses=1
     msgEmpty="Nothing to print"
     PaperLoopLength=1.773107
     PrintLoopLength=0.636100
     bCanBeBase=True
     ItemName="Network Printer"
     Mesh=LodMesh'NetworkPrinter'
     DrawScale=1.775000
     SoundRadius=8
     SoundVolume=96
     AmbientSound=Sound'Ambient.Ambient.HumLow3'
     CollisionRadius=25.000000
     CollisionHeight=30.000000
     Mass=150.000000
     Buoyancy=100.000000
}
