//=============================================================================
// NoteBook1.
//=============================================================================
class NoteBook1 extends tnmInformationDevices;

enum ESkinColor
{
     SKIN_Text,
     SKIN_Image,
     SKIN_TextImg
};

var() ESkinColor SkinColor;

function BeginPlay()
{
     Super.BeginPlay();

     switch (SkinColor)
     {
          case SKIN_Text:     Skin = Texture'NoteBookText'; break;
          case SKIN_Image:     Skin = Texture'NoteBookImage'; break;
          case SKIN_TextImg:   Skin = Texture'NoteBookTextImg'; break;
     }
}


#exec MESH IMPORT MESH=NoteBook1 ANIVFILE=MODELS\NoteBook1_a.3d DATAFILE=MODELS\NoteBook1_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=NoteBook1 X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=NoteBook1 SEQ=All       STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=NoteBook1 SEQ=NoteBook1 STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=NoteBookImage FILE=Textures\Literature\NoteBookImage.pcx GROUP=Skins // Image
#exec TEXTURE IMPORT NAME=NoteBooktextImg FILE=Textures\Literature\NoteBookTextImg.pcx GROUP=Skins // Text & Spider Chart
#exec TEXTURE IMPORT NAME=NoteBookText FILE=Textures\Literature\NoteBooktext.pcx GROUP=Skins  // Text
#exec TEXTURE IMPORT NAME=NoteBookRings FILE=Textures\Literature\NoteBookRings.pcx GROUP=Skins Flags=2 // Text


#exec MESHMAP NEW   MESHMAP=NoteBook1 MESH=NoteBook1
#exec MESHMAP SCALE MESHMAP=NoteBook1 X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=NoteBook1 NUM=0 TEXTURE=NoteBookText
#exec MESHMAP SETTEXTURE MESHMAP=NoteBook1 NUM=2 TEXTURE=NoteBookRings

defaultproperties
{
     bInvincible=True
     bCanBeBase=True
     ItemName="Notepad"
     Mesh=LodMesh'TNMDeco.NoteBook1'
     DrawScale=0.300000
     CollisionRadius=7.000000
     CollisionHeight=1.270000
     Mass=2.000000
     Buoyancy=3.000000
}
