//=============================================================================
// OfficeBin.
//=============================================================================
class OfficeBin extends Containers;

enum ESkinColor
{
	SC_Dark,
	SC_Light
};

var() ESkinColor SkinColor;

function BeginPlay()
{
	Super.BeginPlay();

	switch (SkinColor)
	{
		case SC_Dark:	Skin = Texture'OfficeBinTex1'; break;
		case SC_Light:	Skin = Texture'OfficeBinTex2'; break;
	}
}

#exec MESH IMPORT MESH=OfficeBin ANIVFILE=Models\OfficeBin_a.3d DATAFILE=Models\OfficeBin_d.3d ZEROTEX=1
#exec MESH ORIGIN MESH=OfficeBin X=0 Y=0 Z=0
#exec MESHMAP SCALE MESHMAP=OfficeBin X=0.00390625 Y=0.00390625 Z=0.00390625
#exec MESH SEQUENCE MESH=OfficeBin SEQ=All	STARTFRAME=0	NUMFRAMES=1
#exec MESH SEQUENCE MESH=OfficeBin SEQ=Still	STARTFRAME=0	NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=OfficeBin MESH=OfficeBin

#exec TEXTURE IMPORT NAME=OfficeBinTex1 FILE=Textures\OfficeBin_a.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=OfficeBinTex2 FILE=Textures\OfficeBin_b.pcx GROUP="Skins"
#exec MESHMAP SETTEXTURE MESHMAP=OfficeBin NUM=0 TEXTURE=OfficeBinTex1

defaultproperties
{
     ItemName="Office Bin"
     Mesh=LodMesh'TNMDeco.OfficeBin'
     CollisionRadius=11.300000
     CollisionHeight=16.000000
     Mass=20.000000
     Buoyancy=40.000000
}
