//=============================================================================
// PaperTray.
//=============================================================================
class PaperTray extends TNMDecoration;

enum ESkinColor
{
	SC_ABI,
	SC_GS,
	SC_PDX,
	SC_WC,
	SC_Blank,
};

var() ESkinColor SkinColor;

function BeginPlay()
{
	Super.BeginPlay();

	switch (SkinColor)
	{
		case SC_ABI:	Skin = Texture'PaperABI'; break;
		case SC_GS:	    Skin = Texture'PaperGS'; break;
		case SC_PDX:	Skin = Texture'PaperPDX'; break;
		case SC_WC:	    Skin = Texture'PaperWC'; break;
		case SC_Blank:	Skin = Texture'PaperBlank'; break;
	}
}

#exec mesh IMPORT MESH=PaperTray ANIVFILE=MODELS\PaperTray_a.3d DATAFILE=MODELS\PaperTray_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec mesh ORIGIN MESH=PaperTray X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=PaperTray SEQ=All       STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=PaperTray SEQ=papertray STARTFRAME=0 NUMFRAMES=1

#exec texture IMPORT NAME=JPaperTray1 FILE=Textures\PaperTrayTex1.PCX GROUP=Skins // MATERIAL #0
#exec texture IMPORT NAME=PaperABI    FILE=Textures\PaperABI.PCX GROUP=Skins // MATERIAL #14
#exec texture IMPORT NAME=PaperGS     FILE=Textures\PaperGS.PCX GROUP=Skins // MATERIAL #14
#exec texture IMPORT NAME=PaperPDX    FILE=Textures\PaperPDX.PCX GROUP=Skins // MATERIAL #14
#exec texture IMPORT NAME=PaperWC     FILE=Textures\PaperWC.PCX GROUP=Skins // MATERIAL #14
#exec texture IMPORT NAME=PaperBlank  FILE=Textures\PaperBlank.PCX GROUP=Skins // MATERIAL #14
#exec texture IMPORT NAME=JPaperTray3 FILE=Textures\PTPaper.PCX GROUP=Skins // MATERIAL #15

#exec MESHMAP NEW   MESHMAP=PaperTray MESH=PaperTray
#exec MESHMAP SCALE MESHMAP=PaperTray X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=PaperTray NUM=1 TEXTURE=JPaperTray1
//#exec MESHMAP SETTEXTURE MESHMAP=PaperTray NUM=2 TEXTURE=JPaperTray2
#exec MESHMAP SETTEXTURE MESHMAP=PaperTray NUM=3 TEXTURE=JPaperTray3

defaultproperties
{
     ItemName="Paper Tray"
     Texture=Texture'TNMDeco.Skins.PaperBlank'
     Mesh=LodMesh'TNMDeco.PaperTray'
     CollisionRadius=18.750000
     CollisionHeight=8.800000
     Mass=10.000000
     Buoyancy=100.000000
}
