//=============================================================================
// PetriDish.
//=============================================================================
class PetriDish extends TNMDecoration;

enum ESkinColor
{
	Stuff_Blue,
	Stuff_Green,
	Stuff_Peach,
	Stuff_Red,
	Stuff_Yellow
};

var() ESkinColor SkinColor;

function BeginPlay()
{
	Super.BeginPlay();

	switch (SkinColor)
	{
		case Stuff_Blue:	MultiSkins[2] = Texture'PetriBlue'; break;
		case Stuff_Green:	MultiSkins[2] = Texture'PetriGreen'; break;
		case Stuff_Peach:	MultiSkins[2] = Texture'PetriPeach'; break;
		case Stuff_Red:	    MultiSkins[2] = Texture'PetriRed'; break;
		case Stuff_Yellow:	MultiSkins[2] = Texture'PetriYellow'; break;
	}
}


#exec MESH IMPORT MESH=PetriDish ANIVFILE=MODELS\PetriDish_a.3d DATAFILE=MODELS\PetriDish_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=PetriDish X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=PetriDish SEQ=All            STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=PetriDish SEQ=PetriDishStuff STARTFRAME=0 NUMFRAMES=1

#exec texture IMPORT NAME=JPetriDish1 FILE=Textures\PetriDishTex1.PCX GROUP=Skins // MATERIAL #25
#exec texture IMPORT NAME=PetriBlue FILE=Textures\PetriTexBlue.pcx GROUP=Skins // MATERIAL #26
#exec texture IMPORT NAME=PetriGreen FILE=Textures\PetriTexGreen.pcx GROUP=Skins // MATERIAL #26
#exec texture IMPORT NAME=PetriPeach FILE=Textures\PetriTexPeach.pcx GROUP=Skins // MATERIAL #26
#exec texture IMPORT NAME=PetriRed FILE=Textures\PetriTexRed.pcx GROUP=Skins // MATERIAL #26
#exec texture IMPORT NAME=PetriYellow FILE=Textures\PetriTexYellow.pcx GROUP=Skins // MATERIAL #26

#exec MESHMAP NEW   MESHMAP=PetriDish MESH=PetriDish
#exec MESHMAP SCALE MESHMAP=PetriDish X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=PetriDish NUM=1 TEXTURE=JPetriDish1
#exec MESHMAP SETTEXTURE MESHMAP=PetriDish NUM=2 TEXTURE=PetriBlue

defaultproperties
{
     FragType=Class'DeusEx.GlassFragment'
     ItemName="Petri Dish"
     Mesh=LodMesh'TNMDeco.PetriDish'
     DrawScale=0.300000
     CollisionRadius=8.000000
     CollisionHeight=0.500000
     Mass=5.000000
     Buoyancy=1.000000
}
