//=============================================================================
// Pick.
//=============================================================================
class Pick extends TNMDecoration;

var int FrobCount;

#exec MESH IMPORT MESH=Pick ANIVFILE=MODELS\Pick_a.3d DATAFILE=MODELS\Pick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Pick X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=Pick SEQ=All  STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Pick SEQ=Pick STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=JPick1 FILE=Textures\PickTex1.PCX GROUP=Skins // 01 - default

#exec MESHMAP NEW   MESHMAP=Pick MESH=Pick
#exec MESHMAP SCALE MESHMAP=Pick X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=Pick NUM=1 TEXTURE=JPick1

var localized string message1;
var localized string message2;
var localized string message3;
var localized string message4;
var localized string message5;

function Frob( Actor Frobber, Inventory frobWith )
{
	local DeusExPlayer DXP;

	Super.Frob( Frobber, frobWith );

	DXP = DeusExPlayer( Frobber );
	if ( DXP == None )
		return;

	switch( FrobCount++ )
	{
		case 0:
			DXP.ClientMessage( message1 );
			break;
		case 1:
			DXP.ClientMessage( message2 );
			break;
		case 2:
			DXP.ClientMessage( message3 );
			break;
		case 3:
			DXP.ClientMessage( message4 );
			break;
		case 4:
			DXP.ClientMessage( message5 );
			break;
	}
	FrobCount = FrobCount % 5; //as I recall, uscript lacks a %= operator
}

defaultproperties
{
     message1="This is a pickaxe, it's meant for mining."
     message2="No, you can't use it as a weapon."
     message3="That's what combat knives and riot prods are for."
     message4="What, you'd like to try and dig for gold?"
     message5="Don't you have a mission to do or something!?"
     ItemName="Pick"
     Mesh=LodMesh'TNMDeco.Pick'
     DrawScale=2.800000
     CollisionRadius=30.000000
     CollisionHeight=3.000000
     Mass=50.000000
     Buoyancy=100.000000
     bPushable=false
}
