//=============================================================================
// PongArcade.
//=============================================================================
class PongArcade extends tnmComputers;

var() bool bAltGraphics;

#exec MESH IMPORT MESH=PongArcade ANIVFILE=MODELS\PongArcade_a.3d DATAFILE=MODELS\PongArcade_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=PongArcade X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=PongArcade SEQ=All        STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=PongArcade SEQ=PongArcade STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=PongArcade SEQ=Activate   STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=PongArcade SEQ=Deactivate STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=PongArcade01 FILE=TEXTURES\PongArcade01.PCX GROUP=Skins // Material #25
#exec TEXTURE IMPORT NAME=PongArcade02 FILE=TEXTURES\PongArcade02.PCX GROUP=Skins // Material #26
#exec TEXTURE IMPORT NAME=PongArcadeScreen FILE=TEXTURES\PongArcadeScreen.PCX GROUP=Skins // Material #26

#exec MESHMAP NEW   MESHMAP=PongArcade MESH=PongArcade
#exec MESHMAP SCALE MESHMAP=PongArcade X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=PongArcade NUM=1 TEXTURE=PongArcade01
#exec MESHMAP SETTEXTURE MESHMAP=PongArcade NUM=2 TEXTURE=PongArcade02
#exec MESHMAP SETTEXTURE MESHMAP=PongArcade NUM=3 TEXTURE=PongArcadeScreen

function clean()
{
}

defaultproperties
{
    terminalTypeStr="TNMGUI.tnmPongNetworkTerminal"
    DrawType=DT_Mesh
    Mesh=PongArcade
    ItemName="Arcade Game"
    MultiSkins(1)=Texture'PongArcade01'
    MultiSkins(2)=Texture'PongArcade02'
    MultiSkins(3)=ScriptedTexture'TNM_Misc_Tex.Misc.Pong'
    Drawscale=0.6
    CollisionRadius=40.7
    CollisionHeight=59.8
    Mass=100.000000
    Buoyancy=110.000000
}
