//=============================================================================
// Radish3000.
//=============================================================================
class Radish3000 extends TNMDecoration;

var bool bUsing;
var bool bOpen;
var int numUses;
var localized String msgEmpty;

function Timer()
{
	bUsing = False;
	PlayAnim('Still');
	AmbientSound = None;
}

#exec AUDIO IMPORT FILE=Sounds\cdtrayclose.wav NAME=cdtrayclose GROUP=decosounds
#exec AUDIO IMPORT FILE=Sounds\cdtrayopen.wav NAME=cdtrayopen GROUP=decosounds

function Frob(Actor Frobber, Inventory frobWith)
{
	Super.Frob(Frobber, frobWith);

	if (numUses <= 0)
	{
		if (Pawn(Frobber) != None)
			Pawn(Frobber).ClientMessage(msgEmpty);
		PlaySound(sound'DeusExSounds.Generic.Buzz1');
		return;
	}

	if (bUsing)
		return;

	SetTimer(1.3, False);
	bUsing = True;


//Close tray if it was open, open tray if it was closed

	if (bOpen)
	{
		PlaySound(sound'tnmdeco.decosounds.cdtrayclose');
		PlayAnim('Close');
	}
	else
	{
		PlaySound(sound'tnmdeco.decosounds.cdtrayopen');
		PlayAnim('Open');
	}

	bOpen = !bOpen;
	numUses--;
}




#exec TEXTURE IMPORT NAME=Radish3000_A01 FILE=Textures\Computers\Radish3000_A01.PCX GROUP=Animated
#exec TEXTURE IMPORT NAME=Radish3000_A02 FILE=Textures\Computers\Radish3000_A02.PCX GROUP=Animated
#exec TEXTURE IMPORT NAME=Radish3000_A03 FILE=Textures\Computers\Radish3000_A03.PCX GROUP=Animated
#exec TEXTURE IMPORT NAME=Radish3000_A04 FILE=Textures\Computers\Radish3000_A04.PCX GROUP=Animated
#exec TEXTURE IMPORT NAME=Radish3000_A05 FILE=Textures\Computers\Radish3000_A05.PCX GROUP=Animated
#exec TEXTURE IMPORT NAME=Radish3000_A06 FILE=Textures\Computers\Radish3000_A06.PCX GROUP=Animated
#exec TEXTURE IMPORT NAME=Radish3000_A07 FILE=Textures\Computers\Radish3000_A07.PCX GROUP=Animated


#exec MESH IMPORT MESH=Radish3000 ANIVFILE=MODELS\Radish3000_a.3d DATAFILE=MODELS\Radish3000_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Radish3000 X= Y=5500 Z=-3175

#exec MESH SEQUENCE MESH=Radish3000 SEQ=All      STARTFRAME=0 NUMFRAMES=72
#exec MESH SEQUENCE MESH=Radish3000 SEQ=Open     STARTFRAME=0 NUMFRAMES=35
#exec MESH SEQUENCE MESH=Radish3000 SEQ=Close    STARTFRAME=35 NUMFRAMES=36

#exec MESHMAP NEW   MESHMAP=Radish3000 MESH=Radish3000
#exec MESHMAP SCALE MESHMAP=Radish3000 X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=Radish3000 NUM=1 TEXTURE=Radish3000_A01

defaultproperties
{
     numUses=5
     msgEmpty="Warning, this sliding device is NOT a cupholder."
     ItemName="Radish 3000"
     bPushable=False
     Mesh=LodMesh'TNMDeco.Radish3000'
     CollisionRadius=24.000000
     CollisionHeight=20.000000
     Mass=30.000000
     Buoyancy=10.000000
}
