//=============================================================================
// ProjectileGenerator.
//=============================================================================
class SatelliteGenerator extends ProjectileGenerator;

var() name center;
var() float spiralCoefficient;
var() float orbitCoefficient;

simulated function Tick(float deltaTime)
{
	local int    i, j;
	local int    count;
	local actor  spawnee;
	local float  speed;
	local float  timeVal;
	local vector dir;
	local satellite sat;
	local actor a;

	Super(Effects).Tick(deltaTime);

	// If the owner that I'm attached to is dead, kill me
	if ((attachTag != '') && (Owner == None))
		Destroy();

	// Update timers
	time += deltaTime;
	period += deltaTime;

	// If we're spewing and it's time to stop, stop
	if (bSpewing)
	{
		if (SpewTime > 0)
		{
			if (period >= SpewTime)
			{
				period = 0;
				time   = 0;
				bSpewing = False;
			}
		}
		else
			period = 0;
	}

	// If we're not spewing and it's time to start, start
	else if (!bOnlyOnce)
	{
		if (WaitTime > 0)
		{
			if (period >= WaitTime)
			{
				period = 0;
				time   = 0;
				bSpewing = True;
			}
		}
		else
			period = 0;
	}

	// Are we spewing?
	if (!bSpewing || bFrozen)
		return;

	// Is it time to start spewing?
	if (time >= CheckTime)
	{
		// How many projectiles must we spew?
		if (CheckTime > 0)
		{
			count = int(time/CheckTime);
			time = time - count*CheckTime;
		}
		else
		{
			count = 1;
			time  = 0;
		}
		timeVal = time;

		// Sanity check
		if (count > 5)
			count = 5;

		// If frequency < 1, make spewage random
		if (FRand() <= frequency)
		{
			if (spawnSound != None)
				PlaySound(spawnSound, SLOT_Misc,,, SpawnSoundRadius);

			// Spawn an appropriate number of projectiles
			for (i=0; i<count; i++)  // Number of spews for this tick
			{
				for (j=0; j<numPerSpawn; j++)  // Number of spawns per spew
				{
					// Wayyy down upon the spawnee river...
					spawnee = spawn(ProjectileClass, Owner);
					if (spawnee != None)
					{
						if (bRandomEject)
							dir = VRand();
						else
							dir = vector(Rotation);

						speed = EjectSpeed;
						if (bRandomEject)
							speed *= FRand();

						spawnee.SetRotation(rotator(dir));
						spawnee.Velocity = speed*dir;
						spawnee.Acceleration = dir;
						spawnee.SetLocation(spawnee.Velocity*timeVal+Location);

						if (ProjectileLifeSpan > 0)
							spawnee.LifeSpan = ProjectileLifeSpan;

						sat = satellite(spawnee);
						if (sat != none)
						{
							foreach allactors( class'actor', a, center)
							{
								sat.center = a;
								break;
							}
							sat.spiralCoefficient = spiralCoefficient;
							sat.orbitCoefficient = orbitCoefficient;
						}
					}
				}
				timeVal += CheckTime;
			}
		}
	}

}

defaultproperties
{
     spiralCoefficient=0.995000
     orbitCoefficient=1.000000
     bTriggered=True
}
