//=============================================================================
// SheepPoster.
//=============================================================================
class SheepPoster extends TNMDecoration;

#exec MESH IMPORT MESH=SheepPoster ANIVFILE=MODELS\SheepPoster_a.3d DATAFILE=MODELS\SheepPoster_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=SheepPoster X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=SheepPoster SEQ=All         STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=SheepPoster SEQ=sheepposter STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=SheepPoster MESH=SheepPoster
#exec MESHMAP SCALE MESHMAP=SheepPoster X=0.00390625 Y=0.00390625 Z=0.00390625

#exec texture IMPORT NAME=SheepPosterTex FILE=Textures\sheeppostertex.PCX GROUP=Skins

#exec MESHMAP SETTEXTURE MESHMAP=SheepPoster NUM=1 TEXTURE=SheepPosterTex

function Frob(Actor Other, Inventory frobWith)
{
	local Inventory item;
	local trestkon player;

	player = trestkon(other);

	if (player != none)
	{
		Item = Spawn(class'PosterTube');
		Item.Frob(player, None);
		Item.bInObjectBelt = True;
		if (Item.Owner == player)
			Destroy();
	}
}

defaultproperties
{
     bInvincible=True
     ItemName="Sheep Poster"
     bPushable=False
     Physics=PHYS_None
     Texture=Texture'TNMDeco.Skins.SheepPosterTex'
     Mesh=LodMesh'TNMDeco.SheepPoster'
     DrawScale=1.700000
     CollisionRadius=7.000000
     CollisionHeight=20.000000
     Mass=2.000000
     Buoyancy=1.000000
}
