//=============================================================================
// Shield.
//=============================================================================
class Shield extends TNMDecoration;

var int FrobCount;

enum ESkinColor
{
	SC_ABI,
	SC_Goat
};

var() ESkinColor SkinColor;

var localized string message1;
var localized string message2;
var localized string message3;
var localized string message4;
var localized string message5;

function BeginPlay()
{
	Super.BeginPlay();

	switch (SkinColor)
	{
		case SC_ABI:	Skin = Texture'ABIShieldTex'; break;
		case SC_Goat:	Skin = Texture'GoatShieldTex'; break;
	}
}

#exec mesh IMPORT MESH=Shield ANIVFILE=MODELS\Shield_a.3d DATAFILE=MODELS\Shield_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Shield X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=Shield SEQ=All    STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Shield SEQ=Shield STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=ABIShieldTex FILE=Textures\ABIShield.PCX GROUP=Skins // 01 - default
#exec TEXTURE IMPORT NAME=GoatShieldTex FILE=Textures\GoatShield.PCX GROUP=Skins // 01 - default

#exec MESHMAP NEW   MESHMAP=Shield MESH=Shield
#exec MESHMAP SCALE MESHMAP=Shield X=0.00390625 Y=0.00390625 Z=0.00390625

function Frob( Actor Frobber, Inventory frobWith )
{
	local DeusExPlayer DXP;

	Super.Frob( Frobber, frobWith );

	DXP = DeusExPlayer( Frobber );
	if ( DXP == None )
		return;

	FrobCount++;
	switch( FrobCount )
	{
		case 5:
			DXP.ClientMessage( message1 );
			break;
		case 6:
			DXP.ClientMessage( message2 );
			break;
		case 7:
			DXP.ClientMessage( message3 );
			break;
		case 8:
			DXP.ClientMessage( message4 );
			break;
		case 9:
			DXP.ClientMessage( message5 );
			break;
		default:
	}
}

defaultproperties
{
     message1="It's stuck to the wall."
     message2="Even if you could take it down, it'd probably not be bullet proof."
     message3="This is NOT Morrowind!"
     message4="Yeah I know there's a sword, but you have no idea how to parry anyway..."
     message5="You're getting your dirty finger prints all over the nicely polished deco."
     ItemName="Shield"
     Physics=PHYS_None
     Texture=Texture'TNMDeco.Skins.ABIShieldTex'
     Mesh=LodMesh'TNMDeco.shield'
     DrawScale=2.000000
     CollisionRadius=8.000000
     CollisionHeight=20.000000
     Mass=150.000000
     Buoyancy=100.000000
}
