//=============================================================================
// SpaceStationBlowup.
//=============================================================================
class SpaceStationBlowup extends TNMDecoration;

var bool doSecond;

#exec MESH IMPORT MESH=SpaceStationBlowup ANIVFILE=MODELS\SpaceStationBlowup_a.3d DATAFILE=MODELS\SpaceStationBlowup_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=SpaceStationBlowup X=0 Y=0 Z=0
#exec mesh LODPARAMS MESH=SpaceStationBlowup STRENGTH=100.0

#exec mesh SEQUENCE MESH=SpaceStationBlowup SEQ=All      STARTFRAME=0 NUMFRAMES=60
#exec mesh SEQUENCE MESH=SpaceStationBlowup SEQ=Still    STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=SpaceStationBlowup SEQ=Seq1     STARTFRAME=0 NUMFRAMES=15    RATE=4
#exec mesh SEQUENCE MESH=SpaceStationBlowup SEQ=Seq2     STARTFRAME=15 NUMFRAMES=45   RATE=4

//Clean textures
#exec texture IMPORT NAME=JSpaceStationTexClean1 FILE=Textures\SpaceStationTexClean1.PCX GROUP=Skins // TEX1.DU
#exec texture IMPORT NAME=JSpaceStationTexClean2 FILE=Textures\SpaceStationTexClean2.PCX GROUP=Skins // TEX2.DU
#exec texture IMPORT NAME=JSpaceStationTexClean3 FILE=Textures\SpaceStationTexClean3.PCX GROUP=Skins // TEX3.DU
#exec texture IMPORT NAME=JSpaceStationTexClean4 FILE=Textures\SpaceStationTexClean4.PCX GROUP=Skins // TEX4.DU

//Burnt textures
#exec texture IMPORT NAME=JSpaceStationTexBurnt1 FILE=Textures\SpaceStationTexBurnt1.PCX GROUP=Skins // TEX1.DU
#exec texture IMPORT NAME=JSpaceStationTexBurnt2 FILE=Textures\SpaceStationTexBurnt2.PCX GROUP=Skins // TEX2.DU
#exec texture IMPORT NAME=JSpaceStationTexBurnt3 FILE=Textures\SpaceStationTexBurnt3.PCX GROUP=Skins // TEX3.DU
#exec texture IMPORT NAME=JSpaceStationTexBurnt4 FILE=Textures\SpaceStationTexBurnt4.PCX GROUP=Skins // TEX4.DU

#exec MESHMAP NEW   MESHMAP=SpaceStationBlowup MESH=SpaceStationBlowup
#exec MESHMAP SCALE MESHMAP=SpaceStationBlowup X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=SpaceStationBlowup NUM=1 TEXTURE=JSpaceStationTexClean1
#exec MESHMAP SETTEXTURE MESHMAP=SpaceStationBlowup NUM=2 TEXTURE=JSpaceStationTexClean2
#exec MESHMAP SETTEXTURE MESHMAP=SpaceStationBlowup NUM=3 TEXTURE=JSpaceStationTexClean3
#exec MESHMAP SETTEXTURE MESHMAP=SpaceStationBlowup NUM=4 TEXTURE=JSpaceStationTexClean4

event Trigger( Actor Other, Pawn EventInstigator )
{
	if(doSecond)
		GotoState('BlowUp', 'Seq2');
	else
		GotoState('BlowUp', 'Seq1');
	doSecond=true;
}

state BlowUp
{
Seq1:
	PlayAnim('Seq1');
	FinishAnim();
	Goto('End');
Seq2:
	MultiSkins[1]=Texture'JSpaceStationTexBurnt1';
	MultiSkins[2]=Texture'JSpaceStationTexBurnt2';
	MultiSkins[3]=Texture'JSpaceStationTexBurnt3';
	MultiSkins[4]=Texture'JSpaceStationTexBurnt4';
	PlayAnim('Seq2');
	FinishAnim();
	Goto('End');
End:
}

defaultproperties
{
     bHighlight=false
     ItemName="SpaceStation"
     Mesh=LodMesh'SpaceStationBlowup'
     CollisionRadius=12.000000
     CollisionHeight=40.000000
     Mass=10.000000
     DrawScale=5.00000
     bPushable=false
     Physics=PHYS_None
     Buoyancy=20.000000
}
