//=============================================================================
// SprayPaint.
//=============================================================================
class SprayPaint extends TNMDecoration;

enum ESkinColor
{
	SC_SlightlyCrappy,
	SC_SprayRed,
	SC_SprayBlue,
	SC_SprayYellow
};

var() ESkinColor SkinColor;

function BeginPlay()
{
	Super.BeginPlay();

	switch (SkinColor)
	{
		case SC_SlightlyCrappy:
			MultiSkins[1] = Texture'JSprayPaint1';
			break;
		case SC_SprayRed:
			MultiSkins[1] = Texture'JSprayRed';
			break;
		case SC_SprayBlue:
			MultiSkins[1] = Texture'JSprayBlue';
			break;
		case SC_SprayYellow:
			MultiSkins[1] = Texture'JSprayYellow';
			break;
	}
}

#exec MESH IMPORT MESH=SprayPaint ANIVFILE=MODELS\SprayPaint_a.3d DATAFILE=MODELS\SprayPaint_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH ORIGIN MESH=SprayPaint X=0 Y=0 Z=980

#exec MESH SEQUENCE MESH=SprayPaint SEQ=All        STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=SprayPaint SEQ=SprayPaint STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=JSprayPaint1 FILE=Textures\SprayPaint1.PCX GROUP=Skins // 1 - Default
#exec TEXTURE IMPORT NAME=JSprayRed FILE=Textures\SprayRed.pcx GROUP=Skins // 1 - Default
#exec TEXTURE IMPORT NAME=JSprayBlue FILE=Textures\SprayBlue.pcx GROUP=Skins // 1 - Default
#exec TEXTURE IMPORT NAME=JSprayYellow FILE=Textures\SprayYellow.pcx GROUP=Skins // 1 - Default


#exec MESHMAP NEW   MESHMAP=SprayPaint MESH=SprayPaint
#exec MESHMAP SCALE MESHMAP=SprayPaint X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=SprayPaint NUM=1 TEXTURE=JSprayPaint1

defaultproperties
{
     ItemName="Spray Paint"
     Mesh=LodMesh'TNMDeco.SprayPaint'
     DrawScale=1.600000
     CollisionRadius=2.300000
     CollisionHeight=6.200000
     Mass=20.000000
     Buoyancy=5.000000
}
