//=============================================================================
// Sprinkler.
// Sets off when damaged by a firespawner.
// Puts out the fire within its radius.
// Is disabled when triggered.
//=============================================================================
class Sprinkler extends TNMDecoration;

#exec OBJ LOAD FILE=Ambient
#exec OBJ LOAD FILE=MoverSFX
#exec OBJ LOAD FILE=Effects

#exec MESH IMPORT MESH=Sprinkler ANIVFILE=MODELS\Sprinkler_a.3d DATAFILE=MODELS\Sprinkler_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Sprinkler X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=Sprinkler SEQ=All       STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Sprinkler SEQ=Sprinkler STARTFRAME=0 NUMFRAMES=1

#exec texture IMPORT NAME=JSprinkler1 FILE=Textures\SprinklerTex1.PCX GROUP=Skins // MATERIAL #25
#exec texture IMPORT NAME=JSprinkler_A01 FILE=Textures\Sprinkler_A01.PCX GROUP=Skins
#exec texture IMPORT NAME=JSprinkler_A02 FILE=Textures\Sprinkler_A02.PCX GROUP=Skins
#exec texture IMPORT NAME=JSprinkler_A03 FILE=Textures\Sprinkler_A03.PCX GROUP=Skins
#exec texture IMPORT NAME=JSprinkler_A04 FILE=Textures\Sprinkler_A04.PCX GROUP=Skins
#exec texture IMPORT NAME=JSprinkler_A05 FILE=Textures\Sprinkler_A05.PCX GROUP=Skins
#exec texture IMPORT NAME=JSprinkler_A06 FILE=Textures\Sprinkler_A06.PCX GROUP=Skins
#exec texture IMPORT NAME=JSprinkler_A07 FILE=Textures\Sprinkler_A07.PCX GROUP=Skins
#exec texture IMPORT NAME=JSprinkler_A08 FILE=Textures\Sprinkler_A08.PCX GROUP=Skins

#exec MESHMAP NEW   MESHMAP=Sprinkler MESH=Sprinkler
#exec MESHMAP SCALE MESHMAP=Sprinkler X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=Sprinkler NUM=1 TEXTURE=JSprinkler1
#exec MESHMAP SETTEXTURE MESHMAP=Sprinkler NUM=2 TEXTURE=BlackMaskTex  //Replace with water texture.

var ParticleGenerator	waterGen[4];
var Vector		sprayOffsets[4];

var() bool bEnabled;
var float timer;
var float timer2;
var/*()*/ float extinguishRadius; //deprecated
var/*()*/ float extinguishHeight;

auto state active
{
	function TakeDamage( int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, name DamageType)
	{
		if(DamageType == 'Flamed')
			setOff();
		return;
	}
}

function setOff(optional FireStarter fire)
{
	local actor a;
	if(bEnabled)
	{
		if(event!='')
			foreach allactors(class'actor',a,event)
				a.trigger(none,none);
		timer=10.0;
		if(fire!=none)
			fire.extinguish();
		timer2=0.0;
		WaterOn();
	}
}

function Tick(float deltaTime)
{
	local FireStarter fire;
	local Trestkon t;
	if(timer>0)
	{
		timer-=deltaTime;
		timer2+=deltaTime;
		if(timer2>0.2)
		{
			/*foreach AllActors(Class'FireStarter', fire)
//				if(sqrt((Location.X-fire.Location.X)**2+(Location.Z-fire.Location.Z)**2)<=extinguishRadius && abs(fire.Location.Y-Location.Y)<=extinguishHeight)
				if(VSize(vect(1,1,0)*(Location-fire.Location))<=extinguishRadius&&VSize(vect(0,0,1)*(Location-fire.Location))<=extinguishHeight)
					fire.extinguish();*/

			foreach AllActors(Class'Trestkon', t)
				if(VSize(vect(1,1,0)*(Location-t.Location))<=extinguishRadius&&VSize(vect(0,0,1)*(Location-t.Location))<=extinguishHeight)
					t.ExtinguishFire();

			timer2=0.0;
		}
		if(timer<0)
			WaterOff();
	}
}

function Trigger( Actor Other, Pawn EventInstigator )
{
	bEnabled=!bEnabled;
}

function Destroyed()
{
	local int i;

	for (i=0; i<4; i++)
		if (waterGen[i] != None)
			waterGen[i].DelayedDestroy();

	Super.Destroyed();
}

function WaterOn()
{
	local int i;
	MultiSkins[2]=Texture'JSprinkler_A01';
	PlaySound(sound'ValveOpen',,,, 256, 2.0);
	PlayAnim('On'); //do I want to do this?
	for (i=0; i<4; i++)
		if (waterGen[i] != None)
			waterGen[i].Trigger(None, None);
}

function WaterOff()
{
	local int i;
	MultiSkins[2]=Texture'BlackMaskTex';
	PlaySound(sound'ValveClose',,,, 256, 2.0);
	PlayAnim('Off'); //see above
	for (i=0; i<4; i++)
		if (waterGen[i] != None)
			waterGen[i].UnTrigger(None, None);
}

function PostBeginPlay()
{
	local Vector loc;
	local int i;

	Super.PostBeginPlay();

	// spawn a particle generator
	for (i=0; i<4; i++)
	{
		// rotate the spray offsets into object coordinate space
		loc = sprayOffsets[i];
		loc.Z += CollisionHeight * 1.05;
		loc = loc >> Rotation;
		loc += Location;

		waterGen[i] = Spawn(class'ParticleGenerator', self,, loc, Rotation-rot(12288,0,0));
		if (waterGen[i] != None)
		{
			waterGen[i].particleDrawScale = 0.05;
			waterGen[i].checkTime = 0.05;
			waterGen[i].frequency = 1.0;
			waterGen[i].bGravity = True;
			waterGen[i].bScale = False;
			waterGen[i].bFade = True;
			waterGen[i].ejectSpeed = 100.0;
			waterGen[i].particleLifeSpan = 1.5;
			waterGen[i].numPerSpawn = 3;
			waterGen[i].bRandomEject = True;
			waterGen[i].particleTexture = Texture'Effects.Generated.WtrDrpSmall';
			waterGen[i].bTriggered = True;
			waterGen[i].bInitiallyOn = false;
			waterGen[i].SetBase(self);

			// only have sound on one of them
			if (i == 0)
			{
				waterGen[i].bAmbientSound = True;
				waterGen[i].AmbientSound = Sound'Shower';
				waterGen[i].SoundRadius = 16;
			}
		}
	}

	PlayAnim('Off', 10.0, 0.001);
}


defaultproperties
{
     sprayOffsets(0)=(Z=-16.000000,X=2.000000)
     sprayOffsets(1)=(Z=-16.000000,X=-2.000000)
     sprayOffsets(2)=(Z=-16.000000,Y=2.000000)
     sprayOffsets(3)=(Z=-16.000000,Y=-2.000000)
     bInvincible=True
     ItemName="Sprinkler"
     bPushable=False
     Physics=PHYS_None
     Mesh=LodMesh'Sprinkler'
     DrawScale=0.480000
     CollisionRadius=9.480000
     CollisionHeight=8.410000
     Mass=20.000000
     Buoyancy=10.000000
     bEnabled=true
     extinguishRadius=128.0
     extinguishHeight=256.0
     timer=-1.00
}
