//=============================================================================
// SteeringWheel.
//=============================================================================
class SteeringWheel extends TNMDecoration;

#exec MESH IMPORT MESH=SteeringWheel ANIVFILE=MODELS\SteeringWheel_a.3d DATAFILE=MODELS\SteeringWheel_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec mesh ORIGIN MESH=SteeringWheel X=0 Y=0 Z=0

#exec mesh SEQUENCE MESH=SteeringWheel SEQ=All      	STARTFRAME=0    NUMFRAMES=50
#exec mesh SEQUENCE MESH=SteeringWheel SEQ=Still	STARTFRAME=0	NUMFRAMES=1
#exec mesh SEQUENCE MESH=SteeringWheel SEQ=Close	STARTFRAME=1	NUMFRAMES=25	RATE=10
#exec mesh SEQUENCE MESH=SteeringWheel SEQ=Open		STARTFRAME=26	NUMFRAMES=24	RATE=10

#exec TEXTURE IMPORT NAME=SteeringWheel FILE=Textures\SteeringWheel.PCX GROUP=Skins

#exec MESHMAP new   MESHMAP=SteeringWheel MESH=SteeringWheel
#exec MESHMAP SCALE MESHMAP=SteeringWheel X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=SteeringWheel NUM=1 TEXTURE=SteeringWheel

var() string message;

function Frob(Actor Frobber, Inventory frobWith)
{
	Super.Frob(Frobber, frobWith);
	Pawn(Frobber).ClientMessage(message);
}

defaultproperties
{
     Message="The forklift appears to be out of fuel."
     bInvincible=True
     ItemName="Steering Wheel"
     bPushable=False
     Physics=PHYS_None
     Mesh=LodMesh'TNMDeco.SteeringWheel'
     DrawScale=2.000000
     CollisionRadius=14.400000
     CollisionHeight=3.840000
     Mass=20.000000
     Buoyancy=10.000000
}
