class SubwayMachine extends CigaretteMachine;

var() int Cost;
var() name TicketID;
var localized string alreadygotonemsg;

function beginplay()
{
	if(mesh != lodmesh'Deusexdeco.Cigarettemachine')
		mesh = lodmesh'Deusexdeco.cigarettemachine';

	super.beginplay();
}

function Frob(actor Frobber, Inventory frobWith)
{
	local DeusExPlayer player;
	local Vector loc;
	local Actor product;
	local bool bFree;

	Super(ElectronicDevices).Frob(Frobber, frobWith);
	
	player = DeusExPlayer(Frobber);

	if (player != None)
	{
		bFree=player.Flagbase.GetBool('QC_SUB_SubwayMoneyAlt');
		if (player.Flagbase.getBool('HAS_SubwayPass'))
		{
			player.ClientMessage(alreadygotonemsg);
			return;
		}
		if (numUses <= 0)
		{
			player.ClientMessage(msgEmpty);
			return;
		}

		if (player.Credits >= Cost || bFree)
		{
			PlaySound(sound'VendingCoin', SLOT_None);
			loc = Vector(Rotation) * CollisionRadius * 0.8;
			loc.Z -= CollisionHeight * 0.6; 
			loc += Location;

			product = Spawn(class'SubwayPass', None,, loc);

			if (product != None)
			{
				PlaySound(sound'VendingSmokes', SLOT_None);
				product.Velocity = Vector(Rotation) * 10;
				product.bFixedRotationDir = True;
				product.RotationRate.Pitch = (32768 - Rand(65536)) * 4.0;
				product.RotationRate.Yaw = (32768 - Rand(65536)) * 4.0;
			}

			if(bFree)
				cost=0;
			player.Credits -= cost;
			player.ClientMessage(Sprintf(msgDispensed, cost));
			numUses--;
		}
		else
			player.ClientMessage(Sprintf(msgNoCredits, cost));
	}
}

#exec TEXTURE IMPORT NAME=SubwayMachine_Clean FILE=Textures\SubwayMachine_Clean.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=SubwayMachine_Dirty FILE=Textures\SubwayMachine_Dirty.pcx GROUP="Skins"

defaultproperties
{
     alreadygotonemsg="Your current month pass is valid until October 01, 2004"
     msgDispensed="%d credits deducted from your account. Don't forget to collect your ticket"
     msgNoCredits="Costs %d credits..."
     ItemName="Ticket Machine"
     Mesh=LodMesh'DeusExDeco.CigaretteMachine' // This prevents HDTP from overriding the mesh
     Skin=Texture'TNMDeco.Skins.SubwayMachine_Clean'
     numUses=1
}
