//=============================================================================
// TNMPhasBroom.
//=============================================================================
class TNMBroom extends TNMDecoration;

var int FrobCount;

#exec MESH IMPORT MESH=PhasBroom ANIVFILE=MODELS\PhasBroom_a.3d DATAFILE=MODELS\PhasBroom_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=PhasBroom X=0 Y=0 Z=9750

#exec MESH SEQUENCE MESH=PhasBroom SEQ=All       STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=PhasBroom SEQ=PhasBroom STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=JPhasBroom1 FILE=Textures\PhasBroom1.PCX GROUP=Skins // Material #1

#exec MESHMAP NEW   MESHMAP=PhasBroom MESH=PhasBroom
#exec MESHMAP SCALE MESHMAP=PhasBroom X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=PhasBroom NUM=1 TEXTURE=JPhasBroom1

var localized string message1;
var localized string message2;
var localized string message3;

function Frob( Actor Frobber, Inventory frobWith )
{
	local DeusExPlayer DXP;

	Super.Frob( Frobber, frobWith );

	DXP = DeusExPlayer( Frobber );
	if ( DXP == None )
		return;

	switch( FrobCount++ )
	{
		case 0:
			DXP.ClientMessage( message1 );
			break;
		case 1:
			DXP.ClientMessage( message2 );
			break;
		case 2:
			DXP.ClientMessage( message3 );
			break;
	}
	FrobCount = FrobCount % 3; //as I recall, uscript lacks a %= operator
}

defaultproperties
{
     message1="No, it will not start cleaning the floor itself, this is not Fantasia."
     message2="Do you think you're Harry Potter or something?"
     message3="Sicko."
     FragType=Class'DeusEx.WoodFragment'
     ItemName="Broom"
     Mesh=LodMesh'TNMDeco.PhasBroom'
     DrawScale=0.750000
     Fatness=126
     CollisionRadius=20.000000
     CollisionHeight=36.000000
     Mass=30.000000
     Buoyancy=5.000000
     bPushable=false
}
