//=============================================================================
// TNMBulb.
//=============================================================================
class TNMBulb extends TNMDecoration;

enum ESkinColor
{
	SC_Dirty,
	SC_SemiDirty
};

var() ESkinColor SkinColor;

function BeginPlay()
{
	Super.BeginPlay();

	switch (SkinColor)
	{
		case SC_Dirty:	Skin = Texture'TNMBulbDirty'; break;
		case SC_SemiDirty:	Skin = Texture'TNMBulbSemiDirty'; break;
	}
}


#exec MESH IMPORT MESH=TNMBulb ANIVFILE=MODELS\TNMBulb_a.3d DATAFILE=MODELS\TNMBulb_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=TNMBulb X=0 Y=0 Z=0 PITCH=64

#exec MESH SEQUENCE MESH=TNMBulb SEQ=All  STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=TNMBulb SEQ=Bulb STARTFRAME=0 NUMFRAMES=1

#exec texture IMPORT NAME=TNMBulbDirty FILE=Textures\TNMBulbTex1D.PCX GROUP=Skins // BULB
#exec texture IMPORT NAME=TNMBulbSemiDirty FILE=Textures\TNMBulbTex1.PCX GROUP=Skins // BULB
#exec texture IMPORT NAME=JTNMBulb2 FILE=Textures\TNMBulbTex2.PCX GROUP=Skins // BASE

#exec MESHMAP new   MESHMAP=TNMBulb MESH=TNMBulb
#exec MESHMAP SCALE MESHMAP=TNMBulb X=0.00390625 Y=0.00390625 Z=0.00390625

//#exec MESHMAP SETTEXTURE MESHMAP=TNMBulb NUM=1 TEXTURE=TNMBulbDirty
#exec MESHMAP SETTEXTURE MESHMAP=TNMBulb NUM=2 TEXTURE=JTNMBulb2

defaultproperties
{
     bInvincible=True
     bHighlight=False
     ItemName="Bulb"
     bPushable=False
     Physics=PHYS_None
     Mesh=LodMesh'TNMDeco.TNMBulb'
     DrawScale=0.400000
     CollisionRadius=7.000000
     CollisionHeight=5.000000
     Mass=30.000000
     Buoyancy=5.000000
}
