//=============================================================================
// TNMCameraBlack.
//=============================================================================
class TNMCamera extends SecurityCamera;

var() name Securitychairtag;

#exec MESH IMPORT MESH=TNMCamera ANIVFILE=MODELS\Camera_a.3d DATAFILE=MODELS\Camera_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=TNMCamera X=0 Y=8000 Z=-3000 YAW=64

#exec MESH SEQUENCE MESH=TNMCamera SEQ=All    STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=TNMCamera SEQ=Camera STARTFRAME=0 NUMFRAMES=1

#exec texture IMPORT NAME=CameraBlack FILE=Textures\Camera2.PCX GROUP=Skins // Material #25
#exec texture IMPORT NAME=CameraBrown FILE=Textures\Camera.PCX GROUP=Skins // Material #25

#exec MESHMAP NEW   MESHMAP=TNMCamera MESH=TNMCamera
#exec MESHMAP SCALE MESHMAP=TNMCamera X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=TNMCamera NUM=1 TEXTURE=CameraBlack

var float alarmchecktimer;
var bool balarmed;

enum ESkinColor
{
	SC_Black,
	SC_Brown
};

var() ESkinColor SkinColor;

function BeginPlay()
{
	Super.BeginPlay();

	switch (SkinColor)
	{
		case SC_Black:		multiskins[1] = Texture'camerablack'; break;
		case SC_Brown:  	multiskins[1] = Texture'camerabrown'; break;
	}
}

function Tick(float deltaTime)
{
	local securitychair chair;
	local name securitychairtag;
	local bool bGoActive;

	Super.Tick(deltaTime);

	//Log(bAlarmed,name);
	//Log(alarmCheckTimer, name);

	bGoActive = false;
	foreach AllActors(class'securitychair',chair,securitychairtag)
	{
		if(chair.Occupied())
		{
			bGoActive = true;
		}
	}
	if ( bGoActive )
	{
		bActive = true;
	}
	else
	{
		bActive = false;
		return;
	}

	if (balarmed)
	{
		alarmCheckTimer += deltaTime;

		if (alarmCheckTimer > 1)
		{
			alarmCheckTimer = 0;
			if( securitychairtag != '' )
				foreach AllActors( class 'securitychair', Chair, securitychairtag )
					chair.ALARM();
		}
	}
}


function TriggerEvent(bool bTrigger)
{
local securitychair chair;
	bEventTriggered = bTrigger;
	bTrackPlayer = bTrigger;
	triggerTimer = 0;

	// now, the camera sounds its own alarm
	if (bTrigger)
	{
		// make sure we can't go into stasis while we're alarming
		bStasis = False;

		balarmed = true;
		if( securitychairtag != '' )
			foreach AllActors( class 'securitychair', Chair, securitychairtag )
				chair.ALARM();
	}
	else
	{
		// reset our stasis info
		bStasis = Default.bStasis;

		balarmed = false;
	}
}

//Awful hack for the ATC ID Card
function CheckPlayerVisibility(DeusExPlayer player)
{
	if ( memoryTime > 0)
		super.CheckPlayerVisibility(player);
	else
	{
		bPlayerSeen=false;
	}
//	Log(MemoryTime);
}

defaultproperties
{
     bNoAlarm=True
     Mesh=LodMesh'TNMDeco.TNMCamera'
     DrawScale=0.300000
     CollisionHeight=7.000000
}
