//=============================================================================
// TNMCeilingLight.
//=============================================================================
class TNMCeilingLight extends TNMDecoration;

enum ESkinColor
{
	SC_Dirty,
	SC_SemiDirty,
	SC_Clean
};

var() ESkinColor SkinColor;

function BeginPlay()
{
	Super.BeginPlay();

	switch (SkinColor)
	{
		case SC_Dirty:		Skin = Texture'TNMCeilingLightD'; break;
		case SC_SemiDirty:	Skin = Texture'TNMCeilingLight'; break;
		case SC_Clean:		Skin = Texture'TNMCeilingLightC'; break;
	}
}

#exec MESH IMPORT MESH=TNMCeilingLight ANIVFILE=MODELS\TNMCeilingLight_a.3d DATAFILE=MODELS\TNMCeilingLight_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=TNMCeilingLight X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=TNMCeilingLight SEQ=All          STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=TNMCeilingLight SEQ=CeilingLight STARTFRAME=0 NUMFRAMES=1

#exec texture IMPORT NAME=TNMCeilingLight FILE=Textures\TNMCeilingLightTex.PCX GROUP=Skins // LIGHT
#exec texture IMPORT NAME=TNMCeilingLightD FILE=Textures\TNMCeilingLightTexD.PCX GROUP=Skins
#exec texture IMPORT NAME=TNMCeilingLightC FILE=Textures\TNMCeilingLightTexC.PCX GROUP=Skins

#exec MESHMAP NEW   MESHMAP=TNMCeilingLight MESH=TNMCeilingLight
#exec MESHMAP SCALE MESHMAP=TNMCeilingLight X=0.00390625 Y=0.00390625 Z=0.00390625

//#exec MESHMAP SETTEXTURE MESHMAP=TNMCeilingLight NUM=1 TEXTURE=TNMCeilingLightD

defaultproperties
{
     bInvincible=True
     bHighlight=False
     ItemName="CeilingLight"
     bPushable=False
     Physics=PHYS_None
     Texture=Texture'TNMDeco.Skins.TNMCeilingLightD'
     Mesh=LodMesh'TNMDeco.TNMCeilingLight'
     CollisionRadius=8.000000
     CollisionHeight=1.100000
     Mass=30.000000
     Buoyancy=5.000000
}
