//=============================================================================
// TNMGreyButton.
//=============================================================================
class TNMGreyButton extends TNMDecoration;


// First, the texture import code:
#exec TEXTURE IMPORT NAME=Button1_Grey_Up FILE=Textures\Buttons\Button1_Grey_Up.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_Grey_UpA FILE=Textures\Buttons\Button1_Grey_UpA.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_Grey_Down FILE=Textures\Buttons\Button1_Grey_Down.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_Grey_DownA FILE=Textures\Buttons\Button1_Grey_DownA.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_Grey_0 FILE=Textures\Buttons\Button1_Grey_0.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_Grey_0A FILE=Textures\Buttons\Button1_Grey_0A.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_Grey_1 FILE=Textures\Buttons\Button1_Grey_1.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_Grey_1A FILE=Textures\Buttons\Button1_Grey_1A.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_Grey_2 FILE=Textures\Buttons\Button1_Grey_2.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_Grey_2A FILE=Textures\Buttons\Button1_Grey_2A.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_Grey_3 FILE=Textures\Buttons\Button1_Grey_3.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_Grey_3A FILE=Textures\Buttons\Button1_Grey_3A.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_Grey_4 FILE=Textures\Buttons\Button1_Grey_4.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_Grey_4A FILE=Textures\Buttons\Button1_Grey_4A.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_Grey_5 FILE=Textures\Buttons\Button1_Grey_5.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_Grey_5A FILE=Textures\Buttons\Button1_Grey_5A.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_Grey_6 FILE=Textures\Buttons\Button1_Grey_6.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_Grey_6A FILE=Textures\Buttons\Button1_Grey_6A.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_Grey_7 FILE=Textures\Buttons\Button1_Grey_7.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_Grey_7A FILE=Textures\Buttons\Button1_Grey_7A.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_Grey_8 FILE=Textures\Buttons\Button1_Grey_8.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_Grey_8A FILE=Textures\Buttons\Button1_Grey_8A.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_Grey_9 FILE=Textures\Buttons\Button1_Grey_9.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_Grey_9A FILE=Textures\Buttons\Button1_Grey_9A.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_Grey_Smile FILE=Textures\Buttons\Button1_Grey_Smile.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_Grey_SmileA FILE=Textures\Buttons\Button1_Grey_SmileA.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_Grey_Blank FILE=Textures\Buttons\Button1_Grey_Blank.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_Grey_BlankA FILE=Textures\Buttons\Button1_Grey_BlankA.pcx GROUP="Skins"


enum EButtonType
{
	BT_Up,
	BT_Down,
	BT_0,
	BT_1,
	BT_2,
	BT_3,
	BT_4,
	BT_5,
	BT_6,
	BT_7,
	BT_8,
	BT_9,
	BT_Smile,
	BT_Blank
};

var() EButtonType ButtonType;
var() float buttonLitTime;
var() sound buttonSound1;
var() sound buttonSound2;
var() bool bLit;
var() bool bWaitForEvent;
var bool isPressed;

var Vector	lastLoc, rpcLocation;
var bool		bIsMoving;

replication 
{
	reliable if ( Role == ROLE_Authority )
		rpcLocation;
}

// WOW! What a mess.  I wish you could convert strings to names!
function SetSkin(EButtonType type, bool lit)
{
	switch (type)
	{
		case BT_Up:			if (lit)
							{
								Skin = Texture'Button1_Grey_UpA';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1_Grey_Up';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_Down:		if (lit)
							{
								Skin = Texture'Button1_Grey_DownA';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1_Grey_Down';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_0:			if (lit)
							{
								Skin = Texture'Button1_Grey_0A';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1_Grey_0';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_1:			if (lit)
							{
								Skin = Texture'Button1_Grey_1A';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1_Grey_1';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_2:			if (lit)
							{
								Skin = Texture'Button1_Grey_2A';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1_Grey_2';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_3:			if (lit)
							{
								Skin = Texture'Button1_Grey_3A';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1_Grey_3';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_4:			if (lit)
							{
								Skin = Texture'Button1_Grey_4A';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1_Grey_4';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_5:			if (lit)
							{
								Skin = Texture'Button1_Grey_5A';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1_Grey_5';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_6:			if (lit)
							{
								Skin = Texture'Button1_Grey_6A';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1_Grey_6';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_7:			if (lit)
							{
								Skin = Texture'Button1_Grey_7A';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1_Grey_7';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_8:			if (lit)
							{
								Skin = Texture'Button1_Grey_8A';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1_Grey_8';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_9:			if (lit)
							{
								Skin = Texture'Button1_Grey_9A';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1_Grey_9';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_Smile:		if (lit)
							{
								Skin = Texture'Button1_Grey_SmileA';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1_Grey_Smile';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_Blank:		if (lit)
							{
								Skin = Texture'Button1_Grey_BlankA';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1_Grey_Blank';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
	}
}

function BeginPlay()
{
	Super.BeginPlay();

	SetSkin(ButtonType, bLit);

	if ( Level.NetMode != NM_Standalone )
		rpcLocation = Location;
}

function Trigger(Actor Other, Pawn Instigator)
{
	if (bWaitForEvent)
		Timer();
}

function Timer()
{
	PlaySound(buttonSound2, SLOT_None);
	SetSkin(ButtonType, bLit);
	isPressed = False;
}

function Frob(Actor Frobber, Inventory frobWith)
{
	if (!isPressed)
	{
		isPressed = True;
		PlaySound(buttonSound1, SLOT_None);
		SetSkin(ButtonType, !bLit);
		if (!bWaitForEvent)
			SetTimer(buttonLitTime, False);

		Super.Frob(Frobber, frobWith);
	}
}

singular function SupportActor(Actor standingActor)
{
	// do nothing
}

function Bump(actor Other)
{
	// do nothing
}

simulated function Tick( float deltaTime )
{						  	
	if ( Level.NetMode != NM_Standalone )
	{
		if ( Role == ROLE_Authority )
		{
			// Was moving, now at rest
			if ( bIsMoving && ( Location == lastLoc ))
				rpcLocation = Location;

			bIsMoving = ( Location != lastLoc );
			lastLoc = Location;
		}
		else
		{
			// Our replicated location changed which means the button has come to rest
			if ( lastLoc != rpcLocation )
			{
				SetLocation( rpcLocation );
				lastLoc = rpcLocation;
			}
		}
	}
	Super.Tick( deltaTime );
}

defaultproperties
{
     AmbientGlow=64
     ButtonType=BT_Blank
     buttonLitTime=0.500000
     buttonSound1=Sound'DeusExSounds.Generic.Beep1'
     bInvincible=True
     ItemName="Button"
     bPushable=False
     Physics=PHYS_None
     RemoteRole=ROLE_SimulatedProxy
     Mesh=LodMesh'DeusExDeco.Button1'
     CollisionRadius=2.000000
     CollisionHeight=2.000000
     bCollideWorld=False
     bBlockActors=False
     Mass=5.000000
     Buoyancy=2.000000
}
