//=============================================================================
// TNMRedButton.
//=============================================================================
class TNMRedButton extends TNMDecoration;


// First, the texture import code:
#exec TEXTURE IMPORT NAME=Button1_Red FILE=Textures\Buttons\Button1_Red.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_RedA FILE=Textures\Buttons\Button1_RedA.pcx GROUP="Skins"


var() float buttonLitTime;
var() sound buttonSound1;
var() sound buttonSound2;
var() bool bLit;
var() bool bWaitForEvent;
var bool isPressed;

var Vector	lastLoc, rpcLocation;
var bool		bIsMoving;

replication 
{
	reliable if ( Role == ROLE_Authority )
		rpcLocation;
}

// WOW! What a mess.  I wish you could convert strings to names!
function SetSkin(bool lit)
{
if (lit)
	{
		Skin = Texture'Button1_RedA';
		ScaleGlow = 3.0;
	}
	else
	{
		Skin = Texture'Button1_Red';
		ScaleGlow = Default.ScaleGlow;
	}
}

function BeginPlay()
{
	Super.BeginPlay();

	SetSkin(bLit);

	if ( Level.NetMode != NM_Standalone )
		rpcLocation = Location;
}

function Trigger(Actor Other, Pawn Instigator)
{
	if (bWaitForEvent)
		Timer();
}

function Timer()
{
	PlaySound(buttonSound2, SLOT_None);
	SetSkin(bLit);
	isPressed = False;
}

function Frob(Actor Frobber, Inventory frobWith)
{
	if (!isPressed)
	{
		isPressed = True;
		PlaySound(buttonSound1, SLOT_None);
		SetSkin(!bLit);
		if (!bWaitForEvent)
			SetTimer(buttonLitTime, False);

		Super.Frob(Frobber, frobWith);
	}
}

singular function SupportActor(Actor standingActor)
{
	// do nothing
}

function Bump(actor Other)
{
	// do nothing
}

simulated function Tick( float deltaTime )
{						  	
	if ( Level.NetMode != NM_Standalone )
	{
		if ( Role == ROLE_Authority )
		{
			// Was moving, now at rest
			if ( bIsMoving && ( Location == lastLoc ))
				rpcLocation = Location;

			bIsMoving = ( Location != lastLoc );
			lastLoc = Location;
		}
		else
		{
			// Our replicated location changed which means the button has come to rest
			if ( lastLoc != rpcLocation )
			{
				SetLocation( rpcLocation );
				lastLoc = rpcLocation;
			}
		}
	}
	Super.Tick( deltaTime );
}

defaultproperties
{
     AmbientGlow=64
     buttonLitTime=0.500000
     buttonSound1=Sound'DeusExSounds.Generic.Beep5'
     bInvincible=True
     ItemName="Button"
     bPushable=False
     Physics=PHYS_None
     RemoteRole=ROLE_SimulatedProxy
     Mesh=LodMesh'DeusExDeco.Button1'
     DrawScale=2.000000
     CollisionRadius=4.000000
     CollisionHeight=4.000000
     bCollideWorld=False
     bBlockActors=False
     Mass=5.000000
     Buoyancy=2.000000
}
