//=============================================================================
// TNMSpotLight1.
//=============================================================================
class TNMSpotLight1 extends TNMDecoration;

#exec MESH IMPORT MESH=TNMSpotLight1 ANIVFILE=MODELS\TNMSpotLight1_a.3d DATAFILE=MODELS\TNMSpotLight1_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=TNMSpotLight1 X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=TNMSpotLight1 SEQ=All       STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=TNMSpotLight1 SEQ=SpotLight STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=JTNMSpotLight11 FILE=Textures\SlightTex1.pcx GROUP=Skins // 1 - Default

#exec MESHMAP NEW   MESHMAP=TNMSpotLight1 MESH=TNMSpotLight1
#exec MESHMAP SCALE MESHMAP=TNMSpotLight1 X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=TNMSpotLight1 NUM=1 TEXTURE=JTNMSpotLight11

var() bool bOn;

function Frob(Actor Frobber, Inventory frobWith)
{
	Super.Frob(Frobber, frobWith);

	if (!bOn)
	{
		bOn = True;
		LightType = LT_Steady;
		PlaySound(sound'Switch4ClickOn');
		bUnlit = True;
		ScaleGlow = 2.0;
	}
	else
	{
		bOn = False;
		LightType = LT_None;
		PlaySound(sound'Switch4ClickOff');
		bUnlit = False;
		ResetScaleGlow();
	}
}

function PreBeginPlay()
{
	Super.PreBeginPlay();

	if (bOn)
	{
		LightType = LT_Steady;
		bUnlit = True;
		ScaleGlow = 2.0;
	}

//	log("Spotlight PreBeginPlay:"@bOn$","@bUnlit);
}

//don't reset bUnlit
singular function BaseChange()
{
	return;
}

defaultproperties
{
     FragType=Class'DeusEx.GlassFragment'
     ItemName="Spot Light"
     bPushable=False
     Mesh=LodMesh'TNMDeco.TNMSpotLight1'
     DrawScale=1.845000
     CollisionRadius=20.000000
     CollisionHeight=70.000000
     LightBrightness=255
     LightSaturation=255
     LightRadius=10
     Mass=40.000000
     Buoyancy=40.000000
     bStasis=false //make sure prebeginplay gets called
}
