//=============================================================================
// TAD.
//=============================================================================
class TNMTAD extends ElectronicDevices;

#exec MESH IMPORT MESH=TNMtad ANIVFILE=MODELS\TNMtad_a.3d DATAFILE=MODELS\TNMtad_d.3d X=0 Y=0 Z=0  unmirror=1
#exec MESH ORIGIN MESH=TNMtad X=0 Y=0 Z=0 Yaw=-64

#exec MESH SEQUENCE MESH=TNMtad SEQ=All     STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=TNMtad SEQ=TNMTad STARTFRAME=0 NUMFRAMES=1

#exec texture IMPORT NAME=TNMtadTex1 FILE=Textures\TNMtadTex1.PCX GROUP=Skins // SKIN
#exec texture IMPORT NAME=TNMtadTex2 FILE=Textures\TNMtadTex2.PCX GROUP=Skins // SKIN

#exec MESHMAP NEW   MESHMAP=TNMtad MESH=TNMtad
#exec MESHMAP SCALE MESHMAP=TNMtad X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=TNMtad NUM=0 TEXTURE=TNMtadTex1

var() float beepInterval;
var() sound beepSound;
var HighLight light;
var bool bOn;
var bool bStop;

function Timer()
{
	local DeusExPlayer player;

	if(bStop)
		return;

	player = DeusExPlayer(GetPlayerPawn());
	if (player != None)
	{
		if (light == None)
		{
			light = Spawn(class'HighLight', Self,, Location+vect(0,0,32));
			light.LightType = LT_None;
			light.LightBrightness = 128;
			light.LightHue = 0;
			light.LightSaturation = 16;
		}

		if (player.GetActiveConversation(Self, IM_Frob) != None)
		{
			// beep periodically
			if (!IsInState('Conversation') && !IsInState('FirstPersonConversation'))
			{
				bOn = !bOn;
				if (bOn)
				{
					PlaySound(beepSound, SLOT_Misc,,, 512);
					if (light != None)
						light.LightType = LT_Steady;
					Skin = Texture'TNMTADTex2';
				}
				else
				{
					if (light != None)
						light.LightType = LT_None;
					Skin = Texture'TNMTADTex1';
				}
			}
			else
			{
				if (light != None)
					light.LightType = LT_None;
				Skin = Texture'TNMTADTex1';
				bStop = true;
			}
		}
		else
		{
			// turn off the light
			if (light != None)
				light.Destroy();
			Skin = Texture'TNMTADTex1';
			//SetTimer(0.1, False);
		}
	}
}

function PostBeginPlay()
{
	Super.PostBeginPlay();

	SetTimer(beepInterval*0.5, True);
}

defaultproperties
{
     beepInterval=2.000000
     beepSound=Sound'DeusExSounds.Generic.Beep5'
     ItemName="Telephone Answering Machine"
     Mesh=LodMesh'TNMDeco.TNMTAD'
     CollisionRadius=7.400000
     CollisionHeight=2.130000
     Mass=10.000000
     Buoyancy=5.000000
}
