//=============================================================================
// TNMTV.
//=============================================================================
class TNMTV extends ElectronicDevices;

#exec AUDIO IMPORT FILE=sounds\TVoff.wav NAME=TVoff group=tnmdecosounds
#exec AUDIO IMPORT FILE=sounds\TVon.wav NAME=TVon group=tnmdecosounds

enum ESkinColor
{
     SC_ScreenOn,
     SC_ScreenOff,
     SC_ScreenBroken
};

var() ESkinColor SkinColor;
var() Texture OnTexture;
var() name DestroyTag;
var() sound OnSound;

var bool bfrobable;

function BeginPlay()
{
     Super.BeginPlay();
     updateskin();
     if (SkinColor == SC_ScreenOn)
	AmbientSound = OnSound;
     else
	AmbientSound = none;
}

function updateskin()
{
     switch (SkinColor)
     {
          case SC_ScreenOn:	    MultiSkins[2] = OnTexture; break;
	  case SC_ScreenOff:	    MultiSkins[2] = Texture'TVScreen1'; break;
          case SC_ScreenBroken:     MultiSkins[2] = Texture'TVScreen2'; break;
     }
}

function Frob(actor frobber, inventory frobwith)
{
	local Actor A;

	if ( bfrobable)
	{

	if (SkinColor == SC_ScreenBroken)
		return;

	if (SkinColor == SC_ScreenOff)
	{
		SkinColor = SC_ScreenOn;
		AmbientSound = OnSound;
		PlaySound(Sound'TVon', SLOT_None, 2.0,, 512);
	}
	else if (SkinColor == SC_ScreenOn)
	{
		if (Event != '')
			ForEach AllActors(class 'Actor', A, Event)
				A.trigger(self,Pawn(frobber));
		SkinColor = SC_ScreenOff;
		AmbientSound = none;
		PlaySound(Sound'TVoff', SLOT_None, 2.0,, 512);
	}
	updateskin();
	
	bfrobable = false;
	SetTimer(1, false);
	}
}

simulated function timer()
{
	bfrobable = true;
}

function breakit()
{
local Actor A;
	if ( SkinColor != SC_ScreenBroken ) 
	{
		AISendEvent('LoudNoise', EAITYPE_Audio, 2.0, 512);
		MakeNoise(1.0);
		PlaySound(Sound'DeusExSounds.Generic.GlassBreakSmall', SLOT_None, 2.0,, 512);
		AmbientSound = none;
		SkinColor = SC_ScreenBroken;
		if(DestroyTag!='')
			ForEach AllActors(class 'Actor', A)
				if ( A.Tag == DestroyTag)
					A.trigger(self,none);
	}
}
				

auto state Active
{
	function TakeDamage(int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, name DamageType)
	{
		local float avg;

		if (bStatic || bInvincible)
			return;

		if ((DamageType == 'TearGas') || (DamageType == 'PoisonGas') || (DamageType == 'Radiation'))
			return;

		if ((DamageType == 'EMP') || (DamageType == 'NanoVirus') || (DamageType == 'Shocked'))
			return;

		if (DamageType == 'HalonGas')
			ExtinguishFire();

		if ((DamageType == 'Burned') || (DamageType == 'Flamed'))
		{
			if (bExplosive)		// blow up if we are hit by fire
				HitPoints = 0;
			else if (bFlammable && !Region.Zone.bWaterZone)
			{
				GotoState('Burning');
				return;
			}
		}

		if (Damage >= minDamageThreshold)
			HitPoints -= Damage;
		else
		{
			// sabot damage at 50%
			// explosion damage at 25%
			if (damageType == 'Sabot')
				HitPoints -= Damage * 0.5;
			else if (damageType == 'Exploded')
				HitPoints -= Damage * 0.25;
		}

		if (HitPoints < default.HitPoints)
		{
			breakit();
			updateskin();
		}

		if (HitPoints > 0)		// darken it to show damage (from 1.0 to 0.1 - don't go completely black)
		{
			ResetScaleGlow();
		}
		else	// destroy it!
		{
			DropThings();

			// clear the event to keep Destroyed() from triggering the event
			Event = '';
			avg = (CollisionRadius + CollisionHeight) / 2;
			Instigator = EventInstigator;
			if (Instigator != None)
				MakeNoise(1.0);

			if (fragType == class'WoodFragment')
			{
				if (avg > 20)
					PlaySound(sound'WoodBreakLarge', SLOT_Misc,,, 512);
				else
					PlaySound(sound'WoodBreakSmall', SLOT_Misc,,, 512);
				AISendEvent('LoudNoise', EAITYPE_Audio, , 512);
			}

			// if we have been blown up, then destroy our contents
			// CNN - don't destroy contents now
//			if (DamageType == 'Exploded')
//			{
//				Contents = None;
//				Content2 = None;
//				Content3 = None;
//			}

			if (bExplosive)
			{
				Frag(fragType, Momentum * explosionRadius / 4, avg/20.0, avg/5*3 + 1);
				Explode(HitLocation);
			}
			else
				Frag(fragType, Momentum / 10, avg/20.0, avg/5*3 + 1);
		}
	}
}

#exec mesh IMPORT MESH=TNMTV ANIVFILE=MODELS\TNMTV_a.3d DATAFILE=MODELS\TNMTV_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=TNMTV X=0 Y=0 Z=0 yaw=128

#exec MESH SEQUENCE MESH=TNMTV SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=TNMTV SEQ=TV STARTFRAME=0 NUMFRAMES=1

#exec texture IMPORT NAME=JTNMTV1 FILE=Textures\TV\TVTex1.PCX GROUP=Skins // MATERIAL #25
#exec texture IMPORT NAME=TVScreen1 FILE=Textures\TV\TVOffTex.PCX GROUP=Skins // TVSCREEN.U
#exec texture IMPORT NAME=TVScreen2 FILE=Textures\TV\TVBrokenTex.PCX GROUP=Skins // TVSCREEN.U
#exec texture IMPORT NAME=OnTexture FILE=Textures\TV\TVBrokenTex.PCX GROUP=Skins // TVSCREEN.U

#exec MESHMAP NEW   MESHMAP=TNMTV MESH=TNMTV
#exec MESHMAP SCALE MESHMAP=TNMTV X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=TNMTV NUM=1 TEXTURE=JTNMTV1
#exec MESHMAP SETTEXTURE MESHMAP=TNMTV NUM=2 TEXTURE=TVScreen1
#exec MESHMAP SETTEXTURE MESHMAP=TNMTV NUM=3 TEXTURE=TNMVendor_Glass

defaultproperties
{
     bfrobable=true
     bInvincible=False
     ItemName="TV"
     Mesh=LodMesh'TNMTV'
     CollisionRadius=20.000000
     Drawscale=1.050000
     Texture=Texture'TNMVendor_Glass'
     CollisionHeight=15.000000
     Mass=30.000000
     Buoyancy=5.000000
}
