class TNMVendingMachine extends tnmComputers;

enum ESkinColor
{
	SC_Drink,
	SC_Food,
	SC_Ammo,
	SC_Grenades,
	SC_WeaponMods,
	SC_Tools,
	SC_Equipment
};

var() ESkinColor SkinColor;

struct VendingProduct  {
	var() class<inventory>	DispensedClass;
	var() int               Cost;
	var() Sound		DispensedSound;
};

var() VendingProduct Products[10];
var() string Description;

function SpawnProduct(int index)
{
	local vector loc;
	local actor product;

	PlaySound(sound'VendingCoin', SLOT_None);
	loc = Vector(Rotation) * CollisionRadius * 0.8;
	loc.Z -= CollisionHeight * 0.7;
	loc += Location;

	product = Spawn( Products[index].DispensedClass, None,, loc);

	if (product != None)
	{
		PlaySound(Products[index].DispensedSound, SLOT_None);

		product.Velocity = Vector(Rotation) * 100;
		product.bFixedRotationDir = True;
		product.RotationRate.Pitch = (32768 - Rand(65536)) * 4.0;
		product.RotationRate.Yaw = (32768 - Rand(65536)) * 4.0;
	}
}

state On
{
Begin:
	if (!bOn)
	{
		AdditionalActivation(curFrobber);
		bOn = True;
		ChangePlayerVisibility(False);
		TryInvoke();
	}
}

// ----------------------------------------------------------------------
// state Off
// ----------------------------------------------------------------------

auto state Off
{
Begin:
	if (bOn)
	{
		AdditionalDeactivation(curFrobber);
		ChangePlayerVisibility(True);
		bOn = False;

		// Resume any datalinks that may have started while we were 
		// in the computers (don't want them to start until we pop back out)
		ResumeDataLinks();
		curFrobber = None;
	}
}

function BeginPlay()
{
	Super.BeginPlay();

	switch (SkinColor)
	{
		case SC_Drink:
			MultiSkins[1] = Texture'TNMVendor_DrinkTex1'; // Right-side panel, top
			MultiSkins[2] = Texture'TNMVendor_DrinkTex2'; // Right-side panel, bottom
			MultiSkins[4] = Texture'TNMVendor_DrinkTex1'; // Main cover, top
			MultiSkins[5] = Texture'TNMVendor_DrinkTex2'; // Main cover, bottom
			break;

		case SC_Food:
			MultiSkins[1] = Texture'TNMVendor_FoodTex1';
			MultiSkins[2] = Texture'TNMVendor_FoodTex2';
			MultiSkins[4] = Texture'TNMVendor_FoodTex1';
			MultiSkins[5] = Texture'TNMVendor_FoodTex2';
			break;

		case SC_Ammo:
			Multiskins[1] = Texture'TNMVendor_AmmoTex1';
			MultiSkins[2] = Texture'TNMVendor_AmmoTex2';
			Multiskins[4] = Texture'TNMVendor_AmmoTex1';
			MultiSkins[5] = Texture'TNMVendor_AmmoTex2';
			break;

		case SC_Grenades:
			Multiskins[1] = Texture'TNMVendor_GrenadeTex1';
			Multiskins[2] = Texture'TNMVendor_GrenadeTex2';
			Multiskins[4] = Texture'TNMVendor_GrenadeTex1';
			Multiskins[5] = Texture'TNMVendor_GrenadeTex2';
			break;

		case SC_WeaponMods:
			Multiskins[1] = Texture'TNMVendor_ModsTex1';
			MultiSkins[2] = Texture'TNMVendor_ModsTex2';
			Multiskins[4] = Texture'TNMVendor_ModsTex1';
			MultiSkins[5] = Texture'TNMVendor_ModsTex2';
			break;

		case SC_Tools:
			Multiskins[1] = Texture'TNMVendor_ToolsTex1';
			MultiSkins[2] = Texture'TNMVendor_ToolsTex2';
			Multiskins[4] = Texture'TNMVendor_ToolsTex1';
			MultiSkins[5] = Texture'TNMVendor_ToolsTex2';
			break;

		case SC_Equipment:
			Multiskins[1] = Texture'TNMVendor_EquipmentTex1';
			MultiSkins[2] = Texture'TNMVendor_EquipmentTex2';
			Multiskins[4] = Texture'TNMVendor_EquipmentTex1';
			MultiSkins[5] = Texture'TNMVendor_EquipmentTex2';
			break;
	}
}

function clean()
{
}

#exec mesh IMPORT MESH=WModVendingMachine ANIVFILE=MODELS\WModVendingMachine_a.3d DATAFILE=MODELS\WModVendingMachine_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec mesh ORIGIN MESH=WModVendingMachine X=0 Y=0 Z=0 YAW=64

#exec MESH SEQUENCE MESH=WModVendingMachine SEQ=All         STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=WModVendingMachine SEQ=WModVending STARTFRAME=0 NUMFRAMES=1

#exec texture IMPORT NAME=TNMVendor_DrinkTex1 		FILE=Textures\VendingMachine\TNMVendor_DrinkTex1.pcx GROUP=Skins // TOP
#exec texture IMPORT NAME=TNMVendor_DrinkTex2 		FILE=Textures\VendingMachine\TNMVendor_DrinkTex2.pcx GROUP=Skins // BOTTOM
#exec texture IMPORT NAME=TNMVendor_FoodTex1		FILE=Textures\VendingMachine\TNMVendor_FoodTex1.pcx GROUP=Skins
#exec texture IMPORT NAME=TNMVendor_FoodTex2		FILE=Textures\VendingMachine\TNMVendor_FoodTex2.pcx GROUP=Skins
#exec texture IMPORT NAME=TNMVendor_AmmoTex1		FILE=Textures\VendingMachine\TNMVendor_AmmoTex1.pcx GROUP=Skins
#exec texture IMPORT NAME=TNMVendor_AmmoTex2		FILE=Textures\VendingMachine\TNMVendor_AmmoTex2.pcx GROUP=Skins
#exec texture IMPORT NAME=TNMVendor_GrenadeTex1		FILE=Textures\VendingMachine\TNMVendor_GrenadeTex1.pcx GROUP=Skins
#exec texture IMPORT NAME=TNMVendor_GrenadeTex2		FILE=Textures\VendingMachine\TNMVendor_GrenadeTex2.pcx GROUP=Skins
#exec texture IMPORT NAME=TNMVendor_ModsTex1		FILE=Textures\VendingMachine\TNMVendor_ModsTex1.pcx GROUP=Skins
#exec texture IMPORT NAME=TNMVendor_ModsTex2		FILE=Textures\VendingMachine\TNMVendor_ModsTex2.pcx GROUP=Skins
#exec texture IMPORT NAME=TNMVendor_ToolsTex1		FILE=Textures\VendingMachine\TNMVendor_ToolsTex1.pcx GROUP=Skins
#exec texture IMPORT NAME=TNMVendor_ToolsTex2		FILE=Textures\VendingMachine\TNMVendor_ToolsTex2.pcx GROUP=Skins
#exec texture IMPORT NAME=TNMVendor_EquipmentTex1	FILE=Textures\VendingMachine\TNMVendor_EquipmentTex1.pcx GROUP=Skins
#exec texture IMPORT NAME=TNMVendor_EquipmentTex2	FILE=Textures\VendingMachine\TNMVendor_EquipmentTex2.pcx GROUP=Skins

#exec texture IMPORT NAME=TNMVendor_Glass FILE=Textures\VendingMachine\VendGlassTex1.pcx GROUP=Skins // GLASS.ET


#exec MESHMAP NEW   MESHMAP=WModVendingMachine MESH=WModVendingMachine
#exec MESHMAP SCALE MESHMAP=WModVendingMachine X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=WModVendingMachine NUM=1 TEXTURE=TNMVendor_DrinkTex1
#exec MESHMAP SETTEXTURE MESHMAP=WModVendingMachine NUM=2 TEXTURE=TNMVendor_DrinkTex2
#exec MESHMAP SETTEXTURE MESHMAP=WModVendingMachine NUM=3 TEXTURE=TNMVendor_Glass
#exec MESHMAP SETTEXTURE MESHMAP=WModVendingMachine NUM=4 TEXTURE=TNMVendor_DrinkTex1
#exec MESHMAP SETTEXTURE MESHMAP=WModVendingMachine NUM=5 TEXTURE=TNMVendor_DrinkTex2

defaultproperties
{
     Description="Vending Machine"
     terminalTypeStr="TNMGUI.NetworkTerminalVendingMachine"
     bCanBeBase=True
     ItemName="Vending Machine"
     ScaleGlow=100.000000
     SoundRadius=8
     SoundVolume=96
     AmbientSound=Sound'Ambient.Ambient.HumLow3'
     Texture=Texture'TNMDeco.Skins.TNMVendor_Glass'
     Mesh=LodMesh'TNMDeco.WModVendingMachine'
     CollisionRadius=34.000000
     CollisionHeight=50.000000
     Mass=150.000000
     Buoyancy=100.000000
}
