//=============================================================================
// TNMWallLight.
//=============================================================================
class TNMWallLight extends TNMDecoration;

enum ESkinColor
{
	SC_Dirty,
	SC_SemiDirty
};

var() ESkinColor SkinColor;

function BeginPlay()
{
	Super.BeginPlay();

	switch (SkinColor)
	{
		case SC_Dirty:	Skin = Texture'JTNMWallLight1D'; break;
		case SC_SemiDirty:	Skin = Texture'JTNMWallLight1'; break;
	}
}

#exec MESH IMPORT MESH=TNMWallLight ANIVFILE=MODELS\TNMWallLight_a.3d DATAFILE=MODELS\TNMWallLight_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=TNMWallLight X=0 Y=0 Z=0 PITCH=64

#exec MESH SEQUENCE MESH=TNMWallLight SEQ=All       STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=TNMWallLight SEQ=Walllight STARTFRAME=0 NUMFRAMES=1

#exec texture IMPORT NAME=JTNMWallLight1 FILE=Textures\TNMWallLightTex1.PCX GROUP=Skins // MATERIAL #25
#exec texture IMPORT NAME=JTNMWallLight1D FILE=Textures\TNMWallLightTex1D.PCX GROUP=Skins // MATERIAL #25
#exec texture IMPORT NAME=JTNMWallLight2 FILE=Textures\TNMWallLightTex2.PCX GROUP=Skins // MATERIAL #36

#exec MESHMAP NEW   MESHMAP=TNMWallLight MESH=TNMWallLight
#exec MESHMAP scale MESHMAP=TNMWallLight X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=TNMWallLight NUM=1 TEXTURE=JTNMWallLight2
//#exec MESHMAP SETTEXTURE MESHMAP=TNMWallLight NUM=2 TEXTURE=JTNMWallLight1D

defaultproperties
{
     bInvincible=True
     bHighlight=False
     ItemName="CeilingLight"
     bPushable=False
     Physics=PHYS_None
     Mesh=LodMesh'TNMDeco.TNMWallLight'
     DrawScale=0.550000
     CollisionRadius=3.000000
     CollisionHeight=9.000000
     Mass=30.000000
     Buoyancy=5.000000
}
