class TimedLaserTrigger extends LaserTrigger;

var() float onTime;
var() float offTime;

function Tick(float deltaTime)
{
	super.Tick(deltaTime);
	if (!bconfused)
	{
		if (bIsOn)
		{
			onTime -= deltaTime;
			if (onTime <= 0)
			{
				onTime = default.onTime;
				Untrigger(none,none);
			}
		}
		else
		{
			offTime -= deltaTime;
			if (offTime <= 0)
			{
				offTime = default.offTime;
				trigger(none,none);
			}
		}
	}
}

defaultproperties
{
     ontime=4.000000
     offTime=1.500000
}
