//=============================================================================
// Ashtray.
//=============================================================================
class TowelRack extends TNMDecoration;

enum ESkinColor
{
	SC_Clean,
	SC_Filthy
};

enum TSkinColor
{
	SC_Blue,
	SC_White,
	SC_Brown
};

var() ESkinColor RackColor;
var() TSkinColor TowelColor;

function BeginPlay()
{
	Super.BeginPlay();

	switch (RackColor)
	{
		case SC_Clean:	MultiSkins[0] = Texture'TowelRackTex1'; break;
		case SC_Filthy:	MultiSkins[0] = Texture'TowelRackTex2'; break;
	}
	switch (TowelColor)
	{
		case SC_Blue: 	MultiSkins[1] = Texture'TowelTex1'; break;
		case SC_White: 	MultiSkins[1] = Texture'TowelTex2'; break;
		case SC_Brown: 	MultiSkins[1] = Texture'TowelTex3'; break;
	}
}

#exec MESH IMPORT MESH=TowelRack ANIVFILE=Models\TowelRack_a.3d DATAFILE=Models\TowelRack_d.3d
#exec MESH SEQUENCE MESH=TowelRack SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=TowelRack SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP SCALE MESHMAP=TowelRack X=0.00390625 Y=0.00390625 Z=0.00390625
#exec TEXTURE IMPORT NAME=TowelRackTex1 FILE=Textures\TowelRack_a.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=TowelRackTex2 FILE=Textures\TowelRack_b.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=TowelTex1 FILE=Textures\Towel_a.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=TowelTex2 FILE=Textures\Towel_b.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=TowelTex3 FILE=Textures\Towel_c.pcx GROUP="Skins"
#exec MESHMAP SETTEXTURE MESHMAP=TowelRack NUM=0 TEXTURE=TowelRackTex1
#exec MESHMAP SETTEXTURE MESHMAP=TowelRack NUM=1 TEXTURE=TowelTex1

defaultproperties
{
     bInvincible=True
     bHighlight=False
     ItemName="Towel Rack"
     bPushable=False
     Physics=PHYS_None
     Mesh=LodMesh'TNMDeco.TowelRack'
     CollisionRadius=20.000000
     CollisionHeight=15.000000
     Mass=20.000000
     Buoyancy=40.000000
}
