class TrashArchivePaper extends Trash;

var bool bFadeOut;
var bool bDying;
var float DeathTimer;
var float AccelerationTime;

function Tick(float deltaTime)
{
	local vector loc;

	Super(DeusExDecoration).Tick(deltaTime);

	if (!bFloating && !bStopped)
	{
		Velocity = dir * rnd;
		Velocity += vect(0,0,-32) * AccelerationTime**2;

		if (time >= 1.0)
		{
			rnd = FRand() * 0.5 + 1.5;
			RotationRate = rot * rnd;
			time = 0;
		}
		time += deltaTime;
		AccelerationTime += deltaTime;

		loc = vect(0,0,0);
		loc.Z -= CollisionHeight + 4.0;
		loc += Location;

		// if we haven't moved much since the last frame, stop moving
		if (VSize(Location - lastLoc) < 0.1 || !FastTrace(loc))
			StopMoving();

		lastLoc = Location;
	}

	if (bDying)
	{
		ScaleGlow=DeathTimer/Default.DeathTimer;
		DeathTimer-=deltaTime;
		if(DeathTimer<=0)
			Destroy();
	}
}

function Timer()
{
	if(bFadeOut)
	{
		bDying=true;
		Style=STY_Translucent;
	}
}

function StopMoving()
{
	dir = vect(0,0,0);
	Velocity = dir;
	RotationRate = rot(0,0,0);
	rot = rot(0,0,0);
	rot.Yaw = FRand() * 65535;
	SetRotation(rot);
	bFixedRotationDir = False;
	SetCollisionSize(Default.CollisionRadius, 0.1);
	SetPhysics(PHYS_Falling);
	bStopped = True;
	LifeSpan=0;

	// die after some random time
	SetTimer(10*FRand()+20, False);
}

defaultproperties
{
     ItemName="Paper"
     Mesh=LodMesh'TNM.POPaper'
     CollisionRadius=6.000000
     CollisionHeight=6.000000
     DeathTimer=2.0
     AmbientGlow=16
     bFadeOut=true
}