//=============================================================================
// TrashCan5.
//=============================================================================
class TrashCan5 extends Containers;

enum ESkinColor
{
	SC_Clean,
	SC_Rusty
};

var() ESkinColor SkinColor;

function BeginPlay()
{
	Super.BeginPlay();

	switch (SkinColor)
	{
		case SC_Clean:	Skin = Texture'TrashCan5Tex1'; break;
		case SC_Rusty:	Skin = Texture'TrashCan5Tex2'; break;
	}
}

#exec MESH IMPORT MESH=TrashCan5 ANIVFILE=Models\TrashCan5_a.3d DATAFILE=Models\TrashCan5_d.3d ZEROTEX=1
#exec MESH ORIGIN MESH=TrashCan5 X=0 Y=0 Z=0
#exec MESHMAP SCALE MESHMAP=TrashCan5 X=0.238281 Y=0.238281 Z=0.238281
#exec MESH SEQUENCE MESH=TrashCan5 SEQ=All	STARTFRAME=0	NUMFRAMES=1
#exec MESH SEQUENCE MESH=TrashCan5 SEQ=Still	STARTFRAME=0	NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=TrashCan5 MESH=TrashCan5

#exec TEXTURE IMPORT NAME=TrashCan5Tex1 FILE=Textures\TrashCan5_a.pcx GROUP="Skins" FLAGS=2
#exec TEXTURE IMPORT NAME=TrashCan5Tex2 FILE=Textures\TrashCan5_b.pcx GROUP="Skins" FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=TrashCan5 NUM=0 TEXTURE=TrashCan5Tex1

defaultproperties
{
     bGenerateTrash=True
     bGenerateFlies=True
     ItemName="Trashcan"
     Mesh=LodMesh'TNMDeco.TrashCan5'
     CollisionRadius=13.500000
     CollisionHeight=30.500000
     Mass=40.000000
     Buoyancy=50.000000
}
