//=============================================================================
// WCButton.
//=============================================================================
class WCButton extends TNMDecoration;


// First, the texture import code:
#exec TEXTURE IMPORT NAME=Button1_WC_1 FILE=Textures\Buttons\Button1_WC_1.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_WC_1A FILE=Textures\Buttons\Button1_WC_1A.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_WC_2 FILE=Textures\Buttons\Button1_WC_2.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_WC_2A FILE=Textures\Buttons\Button1_WC_2A.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_WC_3 FILE=Textures\Buttons\Button1_WC_3.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_WC_3A FILE=Textures\Buttons\Button1_WC_3A.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_WC_4 FILE=Textures\Buttons\Button1_WC_4.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_WC_4A FILE=Textures\Buttons\Button1_WC_4A.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_WC_P FILE=Textures\Buttons\Button1_WC_P.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_WC_PA FILE=Textures\Buttons\Button1_WC_PA.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_WC_D FILE=Textures\Buttons\Button1_WC_D.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=Button1_WC_DA FILE=Textures\Buttons\Button1_WC_DA.pcx GROUP="Skins"


enum EButtonType
{
	BT_1,
	BT_2,
	BT_3,
	BT_4,
	BT_P,
	BT_D
};

var() EButtonType ButtonType;
var() float buttonLitTime;
var() sound buttonSound1;
var() sound buttonSound2;
var() bool bLit;
var() bool bWaitForEvent;
var bool isPressed;

var Vector	lastLoc, rpcLocation;
var bool		bIsMoving;

replication 
{
	reliable if ( Role == ROLE_Authority )
		rpcLocation;
}

// WOW! What a mess.  I wish you could convert strings to names!
function SetSkin(EButtonType type, bool lit)
{
	switch (type)
	{
		case BT_1:			if (lit)
							{
								Skin = Texture'Button1_WC_1A';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1_WC_1';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_2:			if (lit)
							{
								Skin = Texture'Button1_WC_2A';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1_WC_2';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_3:			if (lit)
							{
								Skin = Texture'Button1_WC_3A';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1_WC_3';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_4:			if (lit)
							{
								Skin = Texture'Button1_WC_4A';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1_WC_4';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_P:		if (lit)
							{
								Skin = Texture'Button1_WC_PA';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1_WC_P';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_D:		if (lit)
							{
								Skin = Texture'Button1_WC_DA';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1_WC_D';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
	}
}

function BeginPlay()
{
	Super.BeginPlay();

	SetSkin(ButtonType, bLit);

	if ( Level.NetMode != NM_Standalone )
		rpcLocation = Location;
}

function Trigger(Actor Other, Pawn Instigator)
{
	if (bWaitForEvent)
		Timer();
}

function Timer()
{
	PlaySound(buttonSound2, SLOT_None);
	SetSkin(ButtonType, bLit);
	isPressed = False;
}

function Frob(Actor Frobber, Inventory frobWith)
{
	if (!isPressed)
	{
		isPressed = True;
		PlaySound(buttonSound1, SLOT_None);
		SetSkin(ButtonType, !bLit);
		if (!bWaitForEvent)
			SetTimer(buttonLitTime, False);

		Super.Frob(Frobber, frobWith);
	}
}

singular function SupportActor(Actor standingActor)
{
	// do nothing
}

function Bump(actor Other)
{
	// do nothing
}

simulated function Tick( float deltaTime )
{						  	
	if ( Level.NetMode != NM_Standalone )
	{
		if ( Role == ROLE_Authority )
		{
			// Was moving, now at rest
			if ( bIsMoving && ( Location == lastLoc ))
				rpcLocation = Location;

			bIsMoving = ( Location != lastLoc );
			lastLoc = Location;
		}
		else
		{
			// Our replicated location changed which means the button has come to rest
			if ( lastLoc != rpcLocation )
			{
				SetLocation( rpcLocation );
				lastLoc = rpcLocation;
			}
		}
	}
	Super.Tick( deltaTime );
}

defaultproperties
{
     AmbientGlow=64
     buttonLitTime=0.500000
     buttonSound1=Sound'DeusExSounds.Special.Switch1Click'
     bInvincible=True
     ItemName="Button"
     bPushable=False
     Physics=PHYS_None
     RemoteRole=ROLE_SimulatedProxy
     Mesh=LodMesh'DeusExDeco.Button1'
     CollisionRadius=2.000000
     CollisionHeight=2.000000
     bCollideWorld=False
     bBlockActors=False
     Mass=5.000000
     Buoyancy=2.000000
}
