//=============================================================================
// WheeledCar2.
//=============================================================================
class WheeledCar2 extends TNMVehicles;

enum ESkinColor
{
	SC_WheeledCarRed,
    SC_WheeledCarBlue,
	SC_WheeledCarYellow,
	SC_WheeledCarWhite,
	SC_WheeledCarGreen
};

var() ESkinColor SkinColor;

function BeginPlay()
{
	Super.BeginPlay();

	switch (SkinColor)
	{
		case SC_WheeledCarRed:      	Skin = Texture'WheeledCarRed'; break;
        case SC_WheeledCarBlue:	        Skin = Texture'WheeledCarBlue'; break;
		case SC_WheeledCarYellow:	    Skin = Texture'WheeledCarYellow'; break;
		case SC_WheeledCarWhite:	    Skin = Texture'WheeledCarWhite'; break;
		case SC_WheeledCarGreen:	    Skin = Texture'WheeledCarGreen'; break;
	}
}

#exec mesh IMPORT MESH=WheeledCar2 ANIVFILE=MODELS\WheeledCar2_a.3d DATAFILE=MODELS\WheeledCar2_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=WheeledCar2 X=0 Y=0 Z=0

#exec mesh SEQUENCE MESH=WheeledCar2 SEQ=All         STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=WheeledCar2 SEQ=WheeledCar2 STARTFRAME=0 NUMFRAMES=1

#exec texture IMPORT NAME=WheeledCarRed FILE=Textures\WheeledCarRed.PCX GROUP=Skins // MATERIAL #1
#exec texture IMPORT NAME=WheeledCarBlue FILE=Textures\WheeledCarBlue.PCX GROUP=Skins // MATERIAL #1
#exec texture IMPORT NAME=WheeledCarYellow FILE=Textures\WheeledCarYellow.PCX GROUP=Skins // MATERIAL #1
#exec texture IMPORT NAME=WheeledCarWhite FILE=Textures\WheeledCarWhite.PCX GROUP=Skins // MATERIAL #1
#exec texture IMPORT NAME=WheeledCarGreen FILE=Textures\WheeledCarGreen.PCX GROUP=Skins // MATERIAL #1

#exec MESHMAP new   MESHMAP=WheeledCar2 MESH=WheeledCar2
#exec MESHMAP scale MESHMAP=WheeledCar2 X=0.00390625 Y=0.00390625 Z=0.00390625

defaultproperties
{
     ItemName="Car"
     Mesh=LodMesh'WheeledCar2'
     DrawScale=4.900000
     Texture=Texture'WheeledCarRed'
     CollisionRadius=120.000000
     CollisionHeight=40.000000
     Mass=6000.000000
     Buoyancy=1000.000000
}
