//=============================================================================
// WoodCrateSmall.
//=============================================================================
class WoodCrateSmall extends Containers;

enum ESkinColor
{
	SC_DarkWood,
	SC_LightWood,
	SC_OldWood,
	SC_Metalized

};

var() ESkinColor SkinColor;

function BeginPlay()
{
	Super.BeginPlay();

	switch (SkinColor)
	{
		case SC_DarkWood:	Skin = Texture'WoodCrateSmallTex1'; break;
		case SC_LightWood:	Skin = Texture'WoodCrateSmallTex2'; break;
		case SC_OldWood:	Skin = Texture'WoodCrateSmallTex3'; break;
		case SC_Metalized:	Skin = Texture'WoodCrateSmallTex4'; break;
	}
}

// WoodCrateSmall
#exec MESH IMPORT MESH=WoodCrateSmall ANIVFILE=Models\WoodCrateSmall_a.3d DATAFILE=Models\WoodCrateSmall_d.3d ZEROTEX=1
#exec MESH ORIGIN MESH=WoodCrateSmall X=0 Y=0 Z=0
#exec MESHMAP SCALE MESHMAP=WoodCrateSmall X=0.00390625 Y=0.00390625 Z=0.00390625
#exec MESH SEQUENCE MESH=WoodCrateSmall SEQ=All		STARTFRAME=0	NUMFRAMES=1
#exec MESH SEQUENCE MESH=WoodCrateSmall SEQ=Still	STARTFRAME=0	NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=WoodCrateSmall MESH=WoodCrateSmall

#exec TEXTURE IMPORT NAME=WoodCrateSmallTex1 FILE=Textures\WoodCrateSmall_a.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=WoodCrateSmallTex2 FILE=Textures\WoodCrateSmall_b.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=WoodCrateSmallTex3 FILE=Textures\WoodCrateSmall_c.pcx GROUP="Skins"
#exec TEXTURE IMPORT NAME=WoodCrateSmallTex4 FILE=Textures\WoodCrateSmall_d.pcx GROUP="Skins"
#exec MESHMAP SETTEXTURE MESHMAP=WoodCrateSmall NUM=0 TEXTURE=WoodCrateSmallTex1

defaultproperties
{
     HitPoints=15
     FragType=Class'DeusEx.WoodFragment'
     ItemName="Wooden Crate"
     bBlockSight=True
     Mesh=LodMesh'TNMDeco.WoodCrateSmall'
     CollisionRadius=34.000000
     CollisionHeight=24.000000
     Mass=60.000000
     Buoyancy=70.000000
}
