class satellite extends effects;

var actor center;
var float spiralCoefficient;
var float orbitCoefficient;

function Tick(float deltaTime)
{
	local vector r;
	local float vdotv;
	local float rdotr;
	
	r = center.Location - Location;
	vdotv = Velocity Dot Velocity;
	rdotr = r Dot r;
	Velocity -= deltaTime * spiralCoefficient * Velocity;
	Velocity += orbitCoefficient * r * deltaTime;

	if (vsize(Velocity) < 1.0)
		Pop();
}

function Pop()
{
	Destroy();
}

defaultproperties
{
     spiralCoefficient=0.995000
     orbitCoefficient=1.000000
     Physics=PHYS_Projectile
     DrawType=DT_Sprite
     Style=STY_Translucent
     Texture=Texture'DeusExItems.Skins.FlatFXTex45'
     DrawScale=0.050000
}
