class tnmAIPuzzle extends TNMComputers;

var() name 	EnabledFlag;
var() bool 	EnabledFlagDesiredValue;
var() string 	DisabledMessage;

var() name 	SolveEvent;
var() name 	SolveEventHacked;
var() string 	SolvedMessage;
var() Texture 	SolvedTexture;
var() int	SolvedTextureMultiSkinIndex;

var() name 	LayoutStoreFlag;
var() name 	LayoutCheckFlag;
var int 	LayoutCount;
var int		LayoutSelected;

var bool 	bFinished;
var bool	bInitialized;

function Tick(float dt)
{
	local int badlayout;
	local FlagBase flagbase;

	super.Tick(dt);

	if(bInitialized)
		return;

	flagbase=PlayerPawnExt(GetPlayerPawn()).FlagBase;
	if(flagbase==none)
		return;

	badlayout=-1;
	if(LayoutCheckFlag!='')
		badlayout=flagbase.GetInt(LayoutCheckFlag);
	do
	{
		LayoutSelected=rand(LayoutCount);
	} until(LayoutSelected!=badlayout);

	if(LayoutStoreFlag!='')
		flagbase.SetInt(LayoutStoreFlag,LayoutSelected,true);

	bInitialized=true;
}

function Frob(Actor Frobber, Inventory frobWith)
{
	local FlagBase flagbase;

	flagbase=DeusExPlayer(Frobber).flagbase;

	if(EnabledFlag!='' && flagbase.GetBool(EnabledFlag)!=EnabledFlagDesiredValue)
	{
		log(EnabledFlag);
		log(flagbase.GetBool(EnabledFlag));
		DeusExPlayer(Frobber).ClientMessage(DisabledMessage);
		return;
	}

	if(!bFinished)
	{
		super.Frob(Frobber,frobWith);
		return;
	}

	DeusExPlayer(Frobber).ClientMessage(SolvedMessage);
}


defaultproperties
{
     terminalTypeStr="TNMGUI.tnmNetworkTerminalAIPuzzle"
     ItemName="Artificial Intelligence Control Terminal"
     Mesh=LodMesh'TNMDeco.TNMComputer_FS'
     CollisionRadius=17.750000
     CollisionHeight=17.600000
     BindName="ComputerPersonal"
     SolvedMessage="This terminal is now offline."
     DisabledMessage="You have no business using this terminal."
     LayoutCount=13
     SolvedTextureMultiSkinIndex=2
}
