//=============================================================================
// tnmPhone. Plays a random sound clip then a busy signal.
//=============================================================================
class tnmPhone extends ElectronicDevices;

#exec AUDIO IMPORT FILE="Sounds\Phone\Phone01.mp3"	NAME="Phone01"		GROUP="PhoneSounds"
#exec AUDIO IMPORT FILE="Sounds\Phone\Phone02.mp3"	NAME="Phone02"		GROUP="PhoneSounds"
#exec AUDIO IMPORT FILE="Sounds\Phone\Phone03.mp3"	NAME="Phone03"		GROUP="PhoneSounds"
#exec AUDIO IMPORT FILE="Sounds\Phone\Phone04.mp3"	NAME="Phone04"		GROUP="PhoneSounds"
#exec AUDIO IMPORT FILE="Sounds\Phone\Phone05.mp3"	NAME="Phone05"		GROUP="PhoneSounds"
#exec AUDIO IMPORT FILE="Sounds\Phone\Phone06.mp3"	NAME="Phone06"		GROUP="PhoneSounds"
#exec AUDIO IMPORT FILE="Sounds\Phone\Phone07.mp3"	NAME="Phone07"		GROUP="PhoneSounds"
#exec AUDIO IMPORT FILE="Sounds\Phone\Phone08.mp3"	NAME="Phone08"		GROUP="PhoneSounds"
#exec AUDIO IMPORT FILE="Sounds\Phone\Phone09.mp3"	NAME="Phone09"		GROUP="PhoneSounds"
#exec AUDIO IMPORT FILE="Sounds\Phone\Phone10.mp3"	NAME="Phone10"		GROUP="PhoneSounds"
#exec AUDIO IMPORT FILE="Sounds\Phone\Phone11.mp3"	NAME="Phone11"		GROUP="PhoneSounds"
#exec AUDIO IMPORT FILE="Sounds\Phone\Phone12.mp3"	NAME="Phone12"		GROUP="PhoneSounds"
#exec AUDIO IMPORT FILE="Sounds\Phone\Phone13.mp3"	NAME="Phone13"		GROUP="PhoneSounds"
#exec AUDIO IMPORT FILE="Sounds\Phone\Phone14.mp3"	NAME="Phone14"		GROUP="PhoneSounds"
#exec AUDIO IMPORT FILE="Sounds\Phone\Phone15.mp3"	NAME="Phone15"		GROUP="PhoneSounds"
#exec AUDIO IMPORT FILE="Sounds\Phone\Phone16.mp3"	NAME="Phone16"		GROUP="PhoneSounds"
#exec AUDIO IMPORT FILE="Sounds\Phone\Phone17.mp3"	NAME="Phone17"		GROUP="PhoneSounds"
#exec AUDIO IMPORT FILE="Sounds\Phone\Phone18.mp3"	NAME="Phone18"		GROUP="PhoneSounds"
#exec AUDIO IMPORT FILE="Sounds\Phone\Phone19.mp3"	NAME="Phone19"		GROUP="PhoneSounds"

var sound	soundPhoneBusy,
		soundPhoneDialtone;
var bool	bPlayed;
var bool	bUsing;
var sound	soundList[19];
var int		dialToneId;
var string HDTPmeshName, HDTPtexname;


function beginplay()
{
	local mesh M;
	local texture newtex;

	M = lodmesh(dynamicloadObject(HDTPmeshname,class'mesh',true));
	newtex = texture(dynamicloadObject(HDTPtexname,class'texture',true)); 
	if(M != none && newtex != none)
	{
		mesh = M;
		default.Mesh = M;
		skin = newtex;
		default.skin = newtex;
	}

	super.beginplay();
}
	
	

function Timer()
{
	bUsing = False;
	if(dialToneId != default.dialToneId)
	{
		StopSound(dialToneId);
		dialToneId = Default.dialToneId;
	}
}

function Frob(actor Frobber, Inventory frobWith)
{
	local float rnd;
	local flagbase flags;
	local int sid;

	flags = playerpawnext(getplayerpawn()).flagbase;

	Super.Frob(Frobber, frobWith);

	if (bUsing)
		return;

	rnd = FRand();

	bUsing = true;
	SetTimer(3.0, false);

	sid = flags.getInt('PhoneSoundsPlayed');

	if(!bPlayed && sid < arraycount(soundList))
	{
		PlaySound(soundList[sid++], SLOT_Misc,,, 256);
		flags.setInt('PhoneSoundsPlayed', sid, , 0);
		bPlayed = true;
	}
	else
	{
		if(rnd<0.5)
			dialToneId=PlaySound(soundPhoneBusy, SLOT_Misc,,, 256);
		else
			dialToneId=PlaySound(soundPhoneDialtone, SLOT_Misc,,, 256);
	}
}

defaultproperties
{
     soundPhoneBusy=Sound'DeusExSounds.Special.PhoneBusy'
     soundPhoneDialtone=Sound'DeusExSounds.Special.PhoneDialtone'
     ItemName="Telephone"
     Mesh=LodMesh'DeusExDeco.Phone'
     CollisionRadius=11.870000
     CollisionHeight=3.780000
     Mass=20.000000
     Buoyancy=15.000000
     HDTPtexname="HDTPAnim.animated.Phonefr1"
     HDTPmeshname="HDTPDecos.HDTPphone"
     soundList(0)=Sound'TNMDeco.PhoneSounds.Phone01'
     soundList(1)=Sound'TNMDeco.PhoneSounds.Phone02'
     soundList(2)=Sound'TNMDeco.PhoneSounds.Phone03'
     soundList(3)=Sound'TNMDeco.PhoneSounds.Phone04'
     soundList(4)=Sound'TNMDeco.PhoneSounds.Phone05'
     soundList(5)=Sound'TNMDeco.PhoneSounds.Phone06'
     soundList(6)=Sound'TNMDeco.PhoneSounds.Phone07'
     soundList(7)=Sound'TNMDeco.PhoneSounds.Phone08'
     soundList(8)=Sound'TNMDeco.PhoneSounds.Phone09'
     soundList(9)=Sound'TNMDeco.PhoneSounds.Phone10'
     soundList(10)=Sound'TNMDeco.PhoneSounds.Phone11'
     soundList(11)=Sound'TNMDeco.PhoneSounds.Phone12'
     soundList(12)=Sound'TNMDeco.PhoneSounds.Phone13'
     soundList(13)=Sound'TNMDeco.PhoneSounds.Phone14'
     soundList(14)=Sound'TNMDeco.PhoneSounds.Phone15'
     soundList(15)=Sound'TNMDeco.PhoneSounds.Phone16'
     soundList(16)=Sound'TNMDeco.PhoneSounds.Phone17'
     soundList(17)=Sound'TNMDeco.PhoneSounds.Phone18'
     soundList(18)=Sound'TNMDeco.PhoneSounds.Phone19'
     dialToneId=-1
}
