/********
The actual grid on which the puzzle takes place, handles piece placement, coordinate conversion and collision detection
	Shacker (4/21/07)
*********/
class AIPuzzleGrid extends ResizableControlWindow;

/**
Width x height:
2Ver = 52 x 114
2Hor = 118 x 50 (same as "key")
3Ver = 52 x 178
3Hor = 184 x 50
background (not counting the arrow) = 406 x 394 
**/

//imported bg textures and win game sound
#exec TEXTURE IMPORT NAME=AIPuzzle_Bkgrnd1 FILE=Textures\AIPuzzle_Bkgrnd1.pcx GROUP=UI MIPS=OFF FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=AIPuzzle_Bkgrnd2 FILE=Textures\AIPuzzle_Bkgrnd2.pcx GROUP=UI MIPS=OFF FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=AIPuzzle_Bkgrnd3 FILE=Textures\AIPuzzle_Bkgrnd3.pcx GROUP=UI MIPS=OFF FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=AIPuzzle_Bkgrnd4 FILE=Textures\AIPuzzle_Bkgrnd4.pcx GROUP=UI MIPS=OFF FLAGS=2 LODSET=2

#exec AUDIO IMPORT NAME=AIPuzzle_WinGame FILE=Sounds\AIPuzzle_WinGame.wav GROUP=UI

//references
var AIPuzzlePiece    pieces[32];
var int		     piecesDefaultX[32];
var int		     piecesDefaultY[32];
var AIPuzzlePieceKey key;

//for setup
enum PieceType
{
	pKey,
	p2H1,
	p2H2,
	p3H1,
	p3H2,
	p2V1,
	p2V2,
	p3V1,
	p3V2
};

var int setupNumber;
var int puzzleNumber;

//main window
var AIPuzzleWindow PuzzleWin;

//finished?
var bool bPuzzleDone;

//adds the given piece type to the board at grid coords x,y
function AddPiece(PieceType t, int x, int y)
{
	pieces[setupNumber]=AIPuzzlePiece(AddScaledChild(GetType(t)));
	pieces[setupNumber].grid=Self;

	SetPieceGridPos(pieces[setupNumber],X,Y);

	piecesDefaultX[setupNumber]=X;
	piecesDefaultY[setupNumber]=Y;

	if(t==pKey)
		key=AIPuzzlePieceKey(pieces[setupNumber]);

	setupNumber++;
}

//convenience function to map PieceType enum vals to their corresponding class
function Class<AIPuzzlePiece> GetType(PieceType p)
{
	local Class<AIPuzzlePiece> ret;
	switch(p)
	{
		case pKey:
			ret = Class'AIPuzzlePieceKey';
			break;
		case p2H1:
			ret = Class'AIPuzzlePiece2H1';
			break;
		case p2H2:
			ret = Class'AIPuzzlePiece2H2';
			break;
		case p3H1:
			ret = Class'AIPuzzlePiece3H1';
			break;
		case p3H2:
			ret = Class'AIPuzzlePiece3H2';
			break;
		case p2V1:
			ret = Class'AIPuzzlePiece2V1';
			break;
		case p2V2:
			ret = Class'AIPuzzlePiece2V2';
			break;
		case p3V1:
			ret = Class'AIPuzzlePiece3V1';
			break;
		case p3V2:
			ret = Class'AIPuzzlePiece3V2';
			break;
	}
	return ret;
}

//unscaled grid coordinates used for piece placement
function GridCoordinates(int x, int y, out float coordX, out float coordY)
{
	coordX=12+x*66;
	coordY=12+y*64;
}

//pieces call this when dragged in their Tick to attempt to move
function bool AttemptMove(AIPuzzlePiece piece, int X, int Y)
{
	local int	i;
	local float	newX; 
	local float	newY;
	local int	spaces[36];

	if(bPuzzleDone)
		return false;

	if(X<0 || X+piece.gridW>6 || Y<0 || Y+piece.gridH>6 || abs(X-piece.gridX)+abs(Y-piece.gridY)>1)
		return false;

	for(i=0;i<32&&pieces[i]!=None;i++)
	{
		if(pieces[i]!=piece)
		{
			fillRect(spaces, pieces[i].gridX, pieces[i].gridY, pieces[i].gridW, pieces[i].gridH);
		}
	}

	if(!checkRect(spaces, x, y, piece.gridW, piece.gridH))
		return false;

	SetPieceGridPos(piece,X,Y);

//	if(piece==key)
//		CheckForVictory();

	return true;
}

//used for checking available grid spaces
function fillRect(out int rect[36], int x, int y, int w, int h)
{
	local int r;
	local int c;
	for(c=0;c<h;c++)
		for(r=0;r<w;r++)
			rect[(y+c)*6+x+r]++;
}

function bool checkRect(int rect[36], int x, int y, int w, int h)
{
	local int r;
	local int c;
	for(c=0;c<h;c++)
		for(r=0;r<w;r++)
			if(rect[(y+c)*6+x+r]>0)
				return false;
	return true;
}

//ends the game if the key is moved to the dest
function CheckForVictory(optional bool bHacked)
{
	if(key.gridX==4 || bHacked)
	{
		PuzzleWin.PuzzleSolved();
		bPuzzleDone=true;
		key.bWon=true;
	}
}

//close the game window and play the static effect
function Victory()
{
	PuzzleWin.PlaySound(Sound'AIPuzzle_WinGame', 1.0);
	PuzzleWin.PuzzleFinished();
}

//maps mouse coordinates to tiles
function FindGridSquare(float x, float y, out int gridX, out int gridY)
{
	local int i;
	UnscaleCoordinates(x,y);
	for(i=1;i<6;i++)
		if(x<70*i)
			break;
	gridX=i-1;
	for(i=1;i<6;i++)
		if(y<70*i)
			break;
	gridY=i-1;
}

//relocates the given pieces on the grid
function SetPieceGridPos(AIPuzzlePiece piece, int X, int Y)
{
	local float coordX;
	local float coordY;

	GridCoordinates(X,Y,coordX,coordY);
	piece.SetScaledPos(coordX,coordY);
	piece.gridX=X;
	piece.gridY=Y;
}

//just gets the mouse pos and finds its grid coords
function GetMouseGridPos(out int X, out int Y)
{
	local float mouseX;
	local float mouseY;

	GetCursorPos(mouseX, mouseY);
	FindGridSquare(mouseX, mouseY, X, Y);
}

//overridden to enable tick for debugging and init puzzleNumber
event InitWindow()
{
	super.InitWindow();

//	bTickEnabled=true;
}

function ResetPuzzle()
{
	local int i;
	for(i=0;i<32&&pieces[i]!=None;i++)
	{
		pieces[i].Hide();
		pieces[i].DisableWindow();
	}
	InitPieces();
}

function InitPieces()
{
	setupNumber=0;

	switch(puzzleNumber)
	{
		case 0:
			AddPiece(p2H1, 0, 0);
			AddPiece(p2V1, 2, 0);
			AddPiece(p2H2, 0, 1);
			AddPiece(p3V1, 0, 2);
			AddPiece(pKey, 1, 2);
			AddPiece(p3H1, 1, 3);
			AddPiece(p2H1, 0, 5);
			AddPiece(p2V2, 3, 4);
			AddPiece(p2H1, 4, 4);
			AddPiece(p2H2, 4, 5);
			AddPiece(p3V2, 5, 1);
			AddPiece(p2H2, 4, 0);
			break;
		case 1:
			AddPiece(pKey, 0, 2);
			AddPiece(p2H1, 0, 3);
			AddPiece(p2H2, 0, 4);
			AddPiece(p2H1, 0, 5);
			AddPiece(p2H2, 3, 0);
			AddPiece(p2H1, 2, 1);
			AddPiece(p2V1, 2, 2);
			AddPiece(p2V2, 2, 4);
			AddPiece(p2V1, 3, 2);
			AddPiece(p3H1, 3, 4);
			AddPiece(p3H2, 3, 5);
			AddPiece(p2V2, 4, 1);
			AddPiece(p3V1, 5, 0);
			AddPiece(p2H2, 4, 3);
			break;

		case 2:
			AddPiece(p2H2, 0, 0); 
			AddPiece(p2V2, 0, 1); 
			AddPiece(p2H2, 0, 5); 
			AddPiece(p2V2, 1, 2); 
			AddPiece(p2H1, 2, 0); 
			AddPiece(p2H1, 2, 1); 
			AddPiece(p3V2, 2, 2); 
			AddPiece(pKey, 3, 2);
			AddPiece(p3H1, 3, 3);  
			AddPiece(p2V2, 4, 0);  
			AddPiece(p3V1, 5, 0);  
			break;

		case 3:
			AddPiece(p3V2, 0, 0);
			AddPiece(p2H1, 1, 0);
			AddPiece(pKey, 1, 2);
			AddPiece(p2V2, 2, 3);
			AddPiece(p3H1, 2, 5);
			AddPiece(p3V2, 3, 0);
			AddPiece(p3H2, 3, 3);
			AddPiece(p2V2, 5, 4);
			break;

		case 4:
			AddPiece(p2V1, 0, 0);
			AddPiece(pKey, 0, 2);
			AddPiece(p3H2, 0, 5);
			AddPiece(p2H1, 1, 0);
			AddPiece(p3V2, 2, 1);
			AddPiece(p3H1, 3, 3);
			AddPiece(p2V2, 4, 4);
			AddPiece(p3V2, 5, 0);
			break;

		case 5:
			AddPiece(p2H1, 0, 0);
			AddPiece(p3V2, 0, 3);
			AddPiece(p2V2, 1, 2);
			AddPiece(p2H2, 1, 5);
			AddPiece(p2H2, 2, 0);
			AddPiece(p2V2, 2, 1);
			AddPiece(pKey, 3, 2);
			AddPiece(p2H1, 3, 3);
			AddPiece(p2V1, 3, 4);
			AddPiece(p2V1, 4, 0);
			AddPiece(p2H1, 4, 4);
			AddPiece(p2H2, 4, 5);
			AddPiece(p3V1, 5, 1);
			break;

		case 6:
			AddPiece(p2H1, 0, 0);
			AddPiece(p2V1, 0, 2);
			AddPiece(p2H2, 0, 5);
			AddPiece(p2V1, 1, 2);
			AddPiece(p2V1, 2, 0);
			AddPiece(pKey, 2, 2);
			AddPiece(p2H2, 2, 3);
			AddPiece(p2V1, 2, 4);
			AddPiece(p2H1, 4, 1);
			AddPiece(p2V2, 4, 2);
			AddPiece(p2H2, 4, 4);
			AddPiece(p2V1, 5, 2);
			break;

		case 7:
			AddPiece(p2H1, 0, 1);
			AddPiece(p3V2, 0, 2);
			AddPiece(p2H1, 1, 0);
			AddPiece(p3V1, 1, 2);
			AddPiece(p2H1, 1, 5);
			AddPiece(p2H1, 2, 1);
			AddPiece(pKey, 2, 2);
			AddPiece(p2V1, 2, 3);
			AddPiece(p2H2, 3, 0);
			AddPiece(p2V1, 3, 3);
			AddPiece(p2H1, 3, 5);
			AddPiece(p3V1, 4, 1);
			AddPiece(p2H2, 4, 4);
			AddPiece(p3V2, 5, 1);
			break;

		case 8:
			AddPiece(p2H2, 0, 0); 
			AddPiece(p2V2, 0, 1); 
			AddPiece(p2H2, 0, 5); 
			AddPiece(p2V2, 1, 2); 
			AddPiece(p2H1, 2, 0); 
			AddPiece(p2H1, 2, 1); 
			AddPiece(p3V2, 2, 2); 
			AddPiece(pKey, 3, 2);
			AddPiece(p3H1, 3, 3);  
			AddPiece(p2V2, 4, 0);  
			AddPiece(p3V1, 5, 0);
			break;

		case 9:
			AddPiece(p2V1, 0, 0);
			AddPiece(pKey, 0, 2);
			AddPiece(p2H2, 0, 3);
			AddPiece(p3H1, 0, 4);
			AddPiece(p3H1, 0, 5);
			AddPiece(p3H1, 1, 0);
			AddPiece(p2H2, 2, 1);
			AddPiece(p2V2, 2, 2);
			AddPiece(p3V2, 3, 3);
			AddPiece(p2H2, 4, 1);
			AddPiece(p2V2, 4, 4);
			AddPiece(p2V2, 5, 4);
			break;

		case 10:
			AddPiece(p2H1, 0, 0);
			AddPiece(p2H2, 0, 1);
			AddPiece(p3V1, 0, 2);
			AddPiece(p3H2, 0, 5);
			AddPiece(pKey, 1, 2);
			AddPiece(p3H1, 1, 3);
			AddPiece(p2H1, 1, 4);
			AddPiece(p2V1, 2, 0);
			AddPiece(p3V2, 3, 0);
			break;

		case 11:
			AddPiece(p2V1, 1, 2);
			AddPiece(p2H1, 1, 4);
			AddPiece(p2V1, 2, 0);
			AddPiece(pKey, 2, 2);
			AddPiece(p2H2, 2, 3);
			AddPiece(p2H2, 3, 0);
			AddPiece(p2V1, 4, 1);
			AddPiece(p2V1, 4, 3);
			break;

		case 12:
			AddPiece(p2V1, 0, 0);
			AddPiece(pKey, 0, 2);
			AddPiece(p2H2, 1, 1);
			AddPiece(p2V2, 2, 2);
			AddPiece(p2V2, 2, 4);
			AddPiece(p3H1, 3, 0);
			AddPiece(p2V1, 3, 1);
			AddPiece(p2H1, 3, 4);
			AddPiece(p3H1, 3, 5);
			AddPiece(p3V2, 5, 2);
			break;
	}
}

event ConfigurationChanged()
{
	Super.ConfigurationChanged();
//	InitPieces();
	//prevents it from complaining about the pieces requesting configuration during parent configuration in the logs
	AddTimer(0.01, false, , 'InitPieces');
	return;
}

//debug tick, shows mouse coords and relative grid coords
function Tick(float deltaTime)
{
	local float mouseX;
	local float mouseY;

	local int gridX;
	local int gridY;

	GetCursorPos(mouseX, mouseY);
	FindGridSquare(mouseX, mouseY, gridX, gridY);
	
	PuzzleWin.winStatus.SetText("mouseX:"@mouseX@"mouseY:"@mouseY@"gridX:"@gridX@"gridY:"@gridY);
}

defaultproperties
{
     backgroundTextures(0)=Texture'TNMGUI.UI.AIPuzzle_Bkgrnd1'
     backgroundTextures(1)=Texture'TNMGUI.UI.AIPuzzle_Bkgrnd2'
     backgroundTextures(2)=Texture'TNMGUI.UI.AIPuzzle_Bkgrnd3'
     backgroundTextures(3)=Texture'TNMGUI.UI.AIPuzzle_Bkgrnd4'
     backgroundTextureRows=2
     backgroundTextureCols=2
     textureWidth=468.000000
     textureHeight=394.000000
}
