/****
The pieces that are moved around. Handles very little outside of checking for mouse activity and passing
parameters to the grid
	NVShacker 3/22/07
*****/
class AIPuzzlePiece extends ResizableComponentWindow
	abstract;

//grab and place packet sounds
#exec AUDIO IMPORT NAME=AIPuzzle_GrabPacket FILE=Sounds\AIPuzzle_GrabPacket.wav GROUP=UI
#exec AUDIO IMPORT NAME=AIPuzzle_PlacePacket FILE=Sounds\AIPuzzle_PlacePacket.wav GROUP=UI

var AIPuzzleGrid 	grid;

var int			gridX;
var int			gridY;
var int			gridW;
var int			gridH;

var int			ogX;
var int			ogY;

var bool		bMoveVertical;
var bool		bMoveHorizontal;

var bool		bMouseDown;
var bool		bHasMoved;
var int			mouseGridX;
var int			mouseGridY;
var int			mouseOffsetX;
var int			mouseOffsetY;

event InitWindow()
{
	Super.InitWindow();
	bTickEnabled=true;
}

function Tick(float deltaTime)
{
	local int	newGridX;
	local int	newGridY;

	if(grid.bPuzzleDone)
		return;

	if(bMouseDown && !IsKeyDown(IK_LeftMouse))
	{
		bMouseDown=false;
		if(bHasMoved)
			grid.PuzzleWin.PlaySound(Sound'AIPuzzle_PlacePacket', 1.0);
	}

	if(bMouseDown)
	{
		grid.GetMouseGridPos(newGridX, newGridY);

		if(bMoveHorizontal)
		{
			newGridX=max(0, newGridX-mouseOffsetX);
			if(grid.AttemptMove(Self, newGridX, gridY))
				bHasMoved=true;
		}

		if(bMoveVertical)
		{
			newGridY=max(0, newGridY-mouseOffsetY);
			if(grid.AttemptMove(Self, gridX, newGridY))
				bHasMoved=true;
		}

		if(gridX==ogX && gridY==ogY)
			bHasMoved=false;
	}
}

event bool MouseButtonPressed(float pointX, float pointY, EInputKey button, int numClicks)
{
	if(grid.bPuzzleDone)
		return Super.MouseButtonPressed(pointX,pointY,button,numClicks);

	if(!bMouseDown)
	{
		bMouseDown=true;
		bHasMoved=false;
		grid.GetMouseGridPos(mouseOffsetX,mouseOffsetY);
		mouseOffsetX-=gridX;
		mouseOffsetY-=gridY;
		ogX=gridX;
		ogY=gridY;
		grid.PuzzleWin.PlaySound(Sound'AIPuzzle_GrabPacket', 1.0);
		return true;
	}
	return Super.MouseButtonPressed(pointX,pointY,button,numClicks);
}

defaultproperties
{
}
