class AIPuzzlePieceKey extends AIPuzzlePiece;

#exec TEXTURE IMPORT NAME=AIPuzzle_Key FILE=Textures\AIPuzzle_Key.pcx GROUP=UI MIPS=OFF FLAGS=2 LODSET=2

var float wintime;
var float wintimewait;
var color col;
var color colwin;
var bool bWon;

function Tick(float deltaTime)
{
	if(bWon)
	{
		if(wintime>0)
		{
			wintime-=deltaTime;
			if(wintime<=0)
			{
				col=colwin;
				return;
			}
			col.R=wintime/default.wintime*default.col.R+(1.f-wintime/default.wintime)*colwin.R;
			col.G=wintime/default.wintime*default.col.G+(1.f-wintime/default.wintime)*colwin.G;
			col.B=wintime/default.wintime*default.col.B+(1.f-wintime/default.wintime)*colwin.B;
		}
		else if(wintimewait>0)
		{
			wintimewait-=deltaTime;
		}
		else
		{
			grid.Victory();
		}
	}

	if(grid.bPuzzleDone)
		return;

	if(bMouseDown && !IsKeyDown(IK_LeftMouse) && bHasMoved)
		grid.CheckForVictory();

	super.tick(deltaTime);
}

event DrawWindow(GC gc)
{
	gc.SetTileColor(col);
	super.DrawWindow(gc);
}

defaultproperties
{
     gridW=2
     gridH=1
     bMoveHorizontal=True
     displayTexture=Texture'TNMGUI.UI.AIPuzzle_Key'
     textureWidth=118.000000
     textureHeight=50.000000
     wintime=1.000000
     wintimewait=0.600000
     col=(R=255,G=255,B=255)
     colwin=(R=255,G=0,B=255)
}
