/***********
Puzzle for the ai core where you rearrange various objects on a 2D grid only capable of moving
in one direction with the goal of moving one piece to a specific area
	NVShacker 4/17/07
************/
class AIPuzzleWindow extends ComputerUIWindow;

var MenuUIActionButtonWindow	btnExit;
var MenuUIActionButtonWindow	btnReset;

var AIPuzzleGrid		grid;

function CreateControls()
{
	super.CreateControls();
	btnReset=winButtonBar.AddButton("|&Reset Packets", HALIGN_Right);
	btnExit=winButtonBar.AddButton("E|&xit", HALIGN_Right);
	grid=AIPuzzleGrid(winClient.NewChild(Class'AIPuzzleGrid'));
	grid.PuzzleWin=Self;
	grid.SetSize(clientWidth, clientHeight);
}

function bool ButtonActivated( Window buttonPressed )
{
	if(buttonPressed == btnExit)
	{
		CloseScreen("EXIT");
		return true;
	}
	if(buttonPressed == btnReset)
	{
		grid.ResetPuzzle();
		return true;
	}
	return super.ButtonActivated(buttonPressed);
}

event bool VirtualKeyPressed(EInputKey key, bool bRepeat)
{
	local bool bKeyHandled;

	bKeyHandled = True;

	switch(key)
	{
		case IK_X:
			btnExit.PressButton();
			break;

		case IK_R:
			btnReset.PressButton();
			break;

		default:
			bKeyHandled = False;
			break;
	}

	if (!bKeyHandled)
		return Super.VirtualKeyPressed(key, bRepeat);
	return bKeyHandled;
}


//get rid of winStatus
function SetCompOwner(ElectronicDevices newCompOwner)
{
	compOwner = newCompOwner;

	if (winStatus != None)
		winStatus.Hide();

	grid.puzzleNumber=tnmAIPuzzle(compOwner).LayoutSelected;
//	grid.AddTimer
}

//create hack window if player has master hacking skill
function SetNetworkTerminal(NetworkTerminal newTerm)
{
	super.SetNetworkTerminal(newTerm);
	if(player.SkillSystem.GetSkillLevel(class'SkillComputer') >= 3)
	{
		newTerm.bUsesHackWindow=true;
		newTerm.CreateHackWindow();
		newTerm.winHack.SetDetectionTime(0.2,5.0);
		newTerm.winHack.SetWindowAlignments(HALIGN_Right, VALIGN_Top);
	}
}

function PuzzleHacked()
{
	grid.CheckForVictory(true);
	//winTerm.winHack.FinishHack();
	winTerm.winHack.Hide();
}

function PuzzleSolved()
{
	btnExit.SetSensitivity(false);
	btnReset.SetSensitivity(false);
}

function PuzzleFinished()
{
	CloseScreen("STATIC");
}

defaultproperties
{
     escapeAction="LOGOUT"
     Title="AI Packet Control"
     ClientWidth=468
     ClientHeight=394
}
