class APGPuzzleButtonBig extends ButtonWindow;

#exec TEXTURE IMPORT NAME=APG_BigButton0 FILE=Textures\APG_BigBtn0.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2
#exec TEXTURE IMPORT NAME=APG_BigButton1 FILE=Textures\APG_BigBtn1.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2
#exec TEXTURE IMPORT NAME=APG_BigButton2 FILE=Textures\APG_BigBtn2.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2

var DeusExPlayer player;

// Border and Background Translucency
var bool bBorderTranslucent;
var bool bBackgroundTranslucent;
var bool bDrawBorder;

// Default Colors
var Color colBackground;
var Color colBorder;
var Color colHeaderText;
var Color colSensitive;
var Color colInsensitive;

var Texture buttonTextures[3];

// ----------------------------------------------------------------------
// InitWindow()
//
// Responsible for creating the various and sundry sub-windows for
// the keypad popup.
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();
	
	SetSize(64, 64);

	// Get a pointer to the player
	player = DeusExPlayer(GetRootWindow().parentPawn);

	StyleChanged();

	SetSensitivity(false);
}
// ----------------------------------------------------------------------
// DrawWindow()
// ----------------------------------------------------------------------

event DrawWindow(GC gc)
{
	gc.SetStyle(DSTY_Normal);
//	gc.SetStyle(DSTY_Translucent);
	if (bButtonPressed) //+1 to prevent a minor graphical error when the button clips something
		gc.DrawStretchedTexture(0,0, 64, 64, 0, 0, 64, 64, buttonTextures[0]);
	else if (bIsSensitive) //flashing texture
		gc.DrawStretchedTexture(0,0, 64, 64, 0, 0, 64, 64, buttonTextures[2]);
	else
		gc.DrawStretchedTexture(0,0, 64, 64, 0, 0, 64, 64, buttonTextures[1]);		

	// Display darker if the button's insensitive
	if (bIsSensitive)
		gc.SetTextColor(colSensitive);
	else
		gc.SetTextColor(colInsensitive);
}

// ----------------------------------------------------------------------
// StyleChanged()
// ----------------------------------------------------------------------

event StyleChanged()
{
	local ColorTheme theme;

	theme = player.ThemeManager.GetCurrentHUDColorTheme();

	colBackground = theme.GetColorFromName('HUDColor_Background');

	bBorderTranslucent     = player.GetHUDBorderTranslucency();
	bBackgroundTranslucent = player.GetHUDBackgroundTranslucency();
	bDrawBorder            = player.GetHUDBordersVisible();
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     colSensitive=(R=255,G=255,B=255)
     colInsensitive=(R=64,G=64,B=64)
     buttonTextures(0)=Texture'TNMGUI.UI.APG_BigButton0'
     buttonTextures(1)=Texture'TNMGUI.UI.APG_BigButton1'
     buttonTextures(2)=Texture'TNMGUI.UI.APG_BigButton2'
}
