class APGPuzzleButtonSmall extends ButtonWindow;

#exec TEXTURE IMPORT NAME=APG_SmallButton0 FILE=Textures\APG_Button0.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2
#exec TEXTURE IMPORT NAME=APG_SmallButton1 FILE=Textures\APG_Button1.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2

var DeusExPlayer player;

var bool bLightOn;

// Border and Background Translucency
var bool bBorderTranslucent;
var bool bBackgroundTranslucent;
var bool bDrawBorder;

// Default Colors
var Color colBackground;
var Color colBorder;
var Color colHeaderText;
var Color colSensitive;
var Color colInsensitive;

var Texture buttonTextures[2];

function TurnOn()
{
	bLightOn=true;
	AddTimer(0.3,false,,'TurnOff');
}

function TurnOff()
{
	bLightOn=false;
}

// ----------------------------------------------------------------------
// InitWindow()
//
// Responsible for creating the various and sundry sub-windows for
// the keypad popup.
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();
	
	SetSize(32, 32);

	// Get a pointer to the player
	player = DeusExPlayer(GetRootWindow().parentPawn);

	StyleChanged();
}

// ----------------------------------------------------------------------
// DrawWindow()
// ----------------------------------------------------------------------

event DrawWindow(GC gc)
{
	gc.SetStyle(DSTY_Normal);
//	gc.SetStyle(DSTY_Translucent);
	if (bLightOn)
		gc.DrawStretchedTexture(0,0, 32, 32, 0, 0, 32, 32, buttonTextures[1]);
	else
		gc.DrawStretchedTexture(0,0, 32, 32, 0, 0, 32, 32, buttonTextures[0]);		

	// Display darker if the button's insensitive
	if (bIsSensitive)
		gc.SetTextColor(colSensitive);
	else
		gc.SetTextColor(colInsensitive);
}

// ----------------------------------------------------------------------
// StyleChanged()
// ----------------------------------------------------------------------

event StyleChanged()
{
	local ColorTheme theme;

	theme = player.ThemeManager.GetCurrentHUDColorTheme();

	colBackground = theme.GetColorFromName('HUDColor_Background');

	bBorderTranslucent     = player.GetHUDBorderTranslucency();
	bBackgroundTranslucent = player.GetHUDBackgroundTranslucency();
	bDrawBorder            = player.GetHUDBordersVisible();
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     colSensitive=(R=255,G=255,B=255)
     colInsensitive=(R=64,G=64,B=64)
     buttonTextures(0)=Texture'TNMGUI.UI.APG_SmallButton0'
     buttonTextures(1)=Texture'TNMGUI.UI.APG_SmallButton1'
}
