/********
Puzzle for the APG generator
Laid out on 20x15 grid of 32x32 squares

Includes component alignment code that could be easily
applied to virtually any window
	NVShacker 4/16/07
********/
class APGPuzzleWindow extends ComputerUIWindow;

#exec TEXTURE IMPORT NAME=APG_Background1 FILE=Textures\APG_Background1.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2
#exec TEXTURE IMPORT NAME=APG_Background2 FILE=Textures\APG_Background2.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2
#exec TEXTURE IMPORT NAME=APG_Background3 FILE=Textures\APG_Background3.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2
#exec TEXTURE IMPORT NAME=APG_Background4 FILE=Textures\APG_Background4.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2
#exec TEXTURE IMPORT NAME=APG_Background5 FILE=Textures\APG_Background5.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2
#exec TEXTURE IMPORT NAME=APG_Background6 FILE=Textures\APG_Background6.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2
#exec TEXTURE IMPORT NAME=APG_ProgressBarOff FILE=Textures\APG_Indicator0.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2
#exec TEXTURE IMPORT NAME=APG_ProgressBarOn FILE=Textures\APG_Indicator1.pcx GROUP=UI MIPS=OFF FLAGS=0 LODSET=2
#exec TEXTURE IMPORT NAME=APG_Generator_1_0 FILE=Textures\APG_Lamp1_0.pcx GROUP=UI MIPS=OFF FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=APG_Generator_1_1 FILE=Textures\APG_Lamp1_1.pcx GROUP=UI MIPS=OFF FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=APG_Generator_2_0 FILE=Textures\APG_Lamp2_0.pcx GROUP=UI MIPS=OFF FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=APG_Generator_2_1 FILE=Textures\APG_Lamp2_1.pcx GROUP=UI MIPS=OFF FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=APG_Generator_3_0 FILE=Textures\APG_Lamp3_0.pcx GROUP=UI MIPS=OFF FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=APG_Generator_3_1 FILE=Textures\APG_Lamp3_1.pcx GROUP=UI MIPS=OFF FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=APG_Generator_4_0 FILE=Textures\APG_Lamp4_0.pcx GROUP=UI MIPS=OFF FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=APG_Generator_4_1 FILE=Textures\APG_Lamp4_1.pcx GROUP=UI MIPS=OFF FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=APG_Generator_5_0 FILE=Textures\APG_Lamp5_0.pcx GROUP=UI MIPS=OFF FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=APG_Generator_5_1 FILE=Textures\APG_Lamp5_1.pcx GROUP=UI MIPS=OFF FLAGS=2 LODSET=2

//puzzle debug buttons
var bool			puzzleDebug;
var MenuUIActionButtonWindow	puzzleResetGenerators;
var MenuUIActionButtonWindow	puzzleResetActions;
var int				puzzleCur;


//alignment debug buttons
const				alignMax=9;

var bool			alignDebug;
var MenuUIHelpWindow		alignMessage;
var MenuUIActionButtonWindow	alignUp;
var MenuUIActionButtonWindow	alignDown;
var MenuUIActionButtonWindow	alignLeft;
var MenuUIActionButtonWindow	alignRight;
var MenuUIActionButtonWindow	alignSize;
var int				alignX[9];
var int				alignY[9];
var int				alignCur;
var int				alignN;

//computer actor
var tnmComputerAPGPuzzle	puzzle_computer;

//buttons
var MenuUIActionButtonWindow	btnExit;
var APGPuzzleButtonSmall	btnToggles[6];
var APGPuzzleButtonBig		btnSolve;

//textures
var Texture			texProgressBarOn;
var Texture			texProgressBarOff;
var Texture			texGeneratorOn[5];
var Texture			texGeneratorOff[5];

//logic vars
struct ButtonToggle
{
	var int toggles[5];
};
var ButtonToggle button_actions[6];

var int				buttonPushCount;
var int				powerbarLevel;
var int				genActivatedCount;
var int				genList[5]; //can't do bool arrays wtf
var int				genFlicker[5];
var int				flickerLeft;
var bool			genFinish;

function DefaultPuzzleSettings()
{
	button_actions[0].toggles[0]=0;
	button_actions[0].toggles[1]=1;
	button_actions[0].toggles[2]=1;
	button_actions[0].toggles[3]=0;
	button_actions[0].toggles[4]=0;

	button_actions[1].toggles[0]=1;
	button_actions[1].toggles[1]=1;
	button_actions[1].toggles[2]=0;
	button_actions[1].toggles[3]=0;
	button_actions[1].toggles[4]=0;

	button_actions[2].toggles[0]=1;
	button_actions[2].toggles[1]=0;
	button_actions[2].toggles[2]=1;
	button_actions[2].toggles[3]=0;
	button_actions[2].toggles[4]=1;

	button_actions[3].toggles[0]=0;
	button_actions[3].toggles[1]=0;
	button_actions[3].toggles[2]=0;
	button_actions[3].toggles[3]=1;
	button_actions[3].toggles[4]=1;

	button_actions[4].toggles[0]=0;
	button_actions[4].toggles[1]=0;
	button_actions[4].toggles[2]=1;
	button_actions[4].toggles[3]=1;
	button_actions[4].toggles[4]=0;

	button_actions[5].toggles[0]=0;
	button_actions[5].toggles[1]=1;
	button_actions[5].toggles[2]=1;
	button_actions[5].toggles[3]=1;
	button_actions[5].toggles[4]=0;
}

function string PuzzleDebugString()
{
	local string tmp;
	local int i;
	tmp="["$puzzleCur$"] Toggles:";
	for(i=0;i<5;i++)
		if(button_actions[puzzleCur].toggles[i]==1)
			tmp=tmp@(i+1);
	return tmp;
}

function CreateDebugPuzzleControls()
{
	local Color colBlack;
	colBlack.R=0;
	colBlack.G=0;
	colBlack.B=0;

	puzzleCur=0;

	alignMessage = MenuUIHelpWindow(NewChild(Class'MenuUIHelpWindow'));
	alignMessage.SetWordWrap(False);
	alignMessage.SetTextMargins(0, 0);
	alignMessage.SetFont(Font'FontFixedWidthSmall_DS');
	alignMessage.SetTextColor(colBlack);
	alignMessage.SetPos(Grid(1.5),Grid(2));
	alignMessage.setText(PuzzleDebugString());

	puzzleResetGenerators=winButtonBar.AddButton("Reset Generators", HALIGN_Left);
	puzzleResetActions=winButtonBar.AddButton("Reset Button Behavior", HALIGN_Left);
}

function CreateDebugAlignControls()
{
	local Color colBlack;
	colBlack.R=0;
	colBlack.G=0;
	colBlack.B=0;

	alignN=1;
	alignCur=0;

	alignMessage = MenuUIHelpWindow(NewChild(Class'MenuUIHelpWindow'));
	alignMessage.SetWordWrap(False);
	alignMessage.SetTextMargins(0, 0);
	alignMessage.SetFont(Font'FontFixedWidthSmall_DS');
	alignMessage.SetTextColor(colBlack);
	alignMessage.SetPos(Grid(1.5),Grid(2));
	alignMessage.setText("["$alignCur$"] >> X:"@alignX[alignCur]@"Y:"@alignY[alignCur]);

	alignUp=winButtonBar.AddButton("Up", HALIGN_Left);
	alignDown=winButtonBar.AddButton("Down", HALIGN_Left);
	alignLeft=winButtonBar.AddButton("Left", HALIGN_Left);
	alignRight=winButtonBar.AddButton("Right", HALIGN_Left);
	alignSize=winButtonBar.AddButton("1 px", HALIGN_Left);
}

function UpdateDebugAlignment()
{
	local int i;
	local int oX;
	local int oY;

	if(alignDebug)
	{
		for(i=0;i<6;i++)
		{
			oX=alignX[4]+alignX[5]*(i/3)+alignX[6]*(i%3);
			oY=alignY[4]+alignY[5]*(i/3)+alignY[6]*(i%3);
			btnToggles[i].SetPos(oX+10+grid(3+i/3*8),oY+55+grid(7+(i%3)*2));
		}

		oX=alignX[7];
		oY=alignY[7];
		btnSolve.SetPos(oX+10+grid(2),oY+55+grid(4));

		oX=alignX[8];
		oY=alignY[8];
		alignMessage.SetPos(oX+Grid(1.5),oY+Grid(2));

		alignMessage.SetText("["$alignCur$"] >> X:"@alignX[alignCur]@"Y:"@alignY[alignCur]);
	}
}

function CreateControls()
{
	local int i;
	super.CreateControls();

	DefaultPuzzleSettings();

	if(alignDebug)
		CreateDebugAlignControls();
	else if(puzzleDebug)
		CreateDebugPuzzleControls();

//	btnExit=winButtonBar.AddButton("Exit", HALIGN_Right);
	for(i=0;i<6;i++)
	{
		btnToggles[i]=APGPuzzleButtonSmall(NewChild(Class'APGPuzzleButtonSmall'));
		btnToggles[i].SetPos(10+grid(3+i/3*8),55+grid(7+(i%3)*2));
	}
	btnSolve=APGPuzzleButtonBig(NewChild(Class'APGPuzzleButtonBig'));
	btnSolve.SetPos(10+grid(2), 55+grid(4));
	winTitle.Hide();
	AddTimer(0.05,true,,'UpdatePower');
}

function UpdatePower()
{
	local int i;

	if(genFinish)
		return;

	if(powerbarLevel>genActivatedCount*2)
		powerbarLevel--;
	else if(powerbarLevel<genActivatedCount*2)
		powerbarLevel++;
}

function UpdateFlicker(int timerID, int invocations, int clientData)
{
	if(invocations%2==0)
		genFlicker[clientData]=1;
	else
		genFlicker[clientData]=2;
}

function StopFlickerTimer(int timerID, int invocations, int clientData)
{
	RemoveTimer(clientData);
}

function StopFlickerOverride(int timerID, int invocations, int clientData)
{
	genFlicker[clientData]=0;
}

event PostDrawWindow(GC gc)
{
	local int i;
	local int oX;
	local int oY;
	local Texture tex;
	local Color col;

	super.PostDrawWindow(gc);

	if(genFinish)
	{
		col.R=255;
		col.G=0;
		col.B=0;
		GC.SetTileColor(col);
	}

	gc.SetStyle(DSTY_Normal);

	for(i=0;i<10;i++)
	{
		oX=alignX[2]+alignX[3]*i;
		oY=alignY[2]+alignY[3]*i;

		if(i+1<=powerbarLevel)
			tex=texProgressBarOn;
		else
			tex=texProgressBarOff;

		gc.DrawStretchedTexture (oX+42+16+grid(5+i),oY+39+grid(5),grid(1),grid(1),0,0,grid(1),grid(1),tex);
	}

	col.R=255;
	col.G=255;
	col.B=255;
	GC.SetTileColor(col);

	gc.SetStyle(DSTY_Masked);

	for(i=0;i<5;i++)
	{
		oX=alignX[0]+alignX[1]*i;
		oY=alignY[0]+alignY[1]*i;

		if((genList[i]==1 || genFlicker[i]==1) && genFlicker[i]!=2)
			tex=texGeneratorOn[i];
		else
			tex=texGeneratorOff[i];

		gc.DrawStretchedTexture (oX+12+grid(3+i*3),oY+23+grid(2),grid(2),grid(2),0,0,grid(2),grid(2),tex);
	}
}

function float Grid(float dim)
{
	return dim*32;
}

function ToggleGenerator(int num)
{
	local float wait;
	if(genList[num]==0)
	{
		genList[num]=1;
		wait=0.1+0.1*FRand();
		AddTimer(wait,false,AddTimer(0.025,true,num,'UpdateFlicker'),'StopFlickerTimer');
		AddTimer(wait+0.01,false,num,'StopFlickerOverride');
	}
	else
		genList[num]=0;

	if(genList[num]==1)
		genActivatedCount++;
	else
		genActivatedCount--;
}

function SolvePuzzle()
{
	local Actor a;
	foreach player.AllActors(class'Actor',a,puzzle_computer.solve_event)
		a.Trigger(puzzle_computer,player);
	if(buttonPushCount==3)
		foreach player.AllActors(class'Actor',a,puzzle_computer.perfect_solve_event)
			a.Trigger(puzzle_computer,player);
	else if(buttonPushCount>5)
		foreach player.AllActors(class'Actor',a,puzzle_computer.inefficient_solve_event)
			a.Trigger(puzzle_computer,player);
	puzzle_computer.solved=true;
	CloseScreen("EXIT");
}

function GeneratorFinishSequence()
{
	if(powerbarLevel<10)
		powerbarLevel++;
	else
		AddTimer(1.0,false,,'SolvePuzzle');
}

function bool ButtonActivated( Window buttonPressed )
{
	local int i;
	local int c;
	local Actor a;

	local bool handled;

	if(genFinish)
		return true;

	handled=true;

	/*if(buttonPressed == btnExit)
	{
		CloseScreen("EXIT");
		return true;
	}*/

	if(buttonPressed == btnSolve)
	{
		powerbarLevel=0;
		genFinish=true;
		PlaySound(Sound'DeusExSounds.Generic.Beep2', 1.0);
		AddTimer(0.2,true,,'GeneratorFinishSequence');
		buttonPushCount++;
		return true;
	}

	for(i=0;i<6;i++)
		if(buttonPressed==btnToggles[i])
		{
			btnToggles[i].TurnOn();
			PlaySound(Sound'DeusExSounds.Generic.Beep1', 1.0);
			break;
		}

	if(i<6)
	{
		for(c=0;c<5;c++)
			if(button_actions[i].toggles[c]==1)
				ToggleGenerator(c);
	}
	else
		handled=false;

	if(genActivatedCount==5)
	{
		PlaySound(Sound'DeusExSounds.UserInterface.Menu_BuySkills', 1.0);
		btnSolve.SetSensitivity(true);
	}
	else
		btnSolve.SetSensitivity(false);

/*	switch(i)
	{
		case 0: //flux capacitator
			ToggleGenerator(1);
			ToggleGenerator(2);
			break;

		case 1: //input stabilizer
			ToggleGenerator(0);
			ToggleGenerator(1);
			break;

		case 2: //output regulator
			ToggleGenerator(3);
			ToggleGenerator(4);
			break;

		case 3: //flow controller
			ToggleGenerator(2);
			ToggleGenerator(3);
			break;

		case 4: //annihilation plant
			ToggleGenerator(1);
			ToggleGenerator(2);
			ToggleGenerator(3);
			break;

		case 5: //particle converter
			ToggleGenerator(0);
			ToggleGenerator(2);
			ToggleGenerator(4);
			break;

		default: //how this could happen? I have no clue
			handled=false;
	}*/

	if(alignDebug && !handled)
	{
		handled=true;

		switch(buttonPressed)
		{
		case alignUp:
			alignY[alignCur]-=alignN;
			break;
		case alignDown:
			alignY[alignCur]+=alignN;
			break;
		case alignLeft:
			alignX[alignCur]-=alignN;
			break;
		case alignRight:
			alignX[alignCur]+=alignN;
			break;
		case alignSize:
			if(alignN<32)
				alignN*=2;
			else
				alignN=1;
			alignSize.SetButtonText(""$alignN@"px");
			break;
		default: //how this could happen? I have no clue
			handled=false;
		}

		UpdateDebugAlignment();
	}

	if(puzzleDebug && !handled)
	{
		handled=true;

		switch(buttonPressed)
		{
		case puzzleResetGenerators:
			for(i=0;i<5;i++)
				if(genList[i]==1)
					ToggleGenerator(i);
			break;
		case puzzleResetActions:
			DefaultPuzzleSettings();
			break;
		default:
			handled=false;
		}

		alignMessage.SetText(PuzzleDebugString());
	}

	return handled||Super.ButtonActivated(buttonPressed);
}

event bool VirtualKeyPressed(EInputKey key, bool bRepeat)
{
	local bool bKeyHandled;

	if(!alignDebug && !puzzleDebug)
		return Super.VirtualKeyPressed(key, bRepeat);	

	bKeyHandled = True;

	if(!alignDebug && puzzleDebug)
	{
		switch(key)
		{
			//reserve keys that are checked in Tick
			case IK_1:
			case IK_NumPad1:
				if(button_actions[puzzleCur].toggles[0]==1)
					button_actions[puzzleCur].toggles[0]=0;
				else
					button_actions[puzzleCur].toggles[0]=1;
				break;
			case IK_NumPad2:
			case IK_2:
				if(button_actions[puzzleCur].toggles[1]==1)
					button_actions[puzzleCur].toggles[1]=0;
				else
					button_actions[puzzleCur].toggles[1]=1;
				break;
			case IK_NumPad3:
			case IK_3:
				if(button_actions[puzzleCur].toggles[2]==1)
					button_actions[puzzleCur].toggles[2]=0;
				else
					button_actions[puzzleCur].toggles[2]=1;
				break;
			case IK_NumPad4:
			case IK_4:
				if(button_actions[puzzleCur].toggles[3]==1)
					button_actions[puzzleCur].toggles[3]=0;
				else
					button_actions[puzzleCur].toggles[3]=1;
				break;
			case IK_NumPad5:
			case IK_5:
				if(button_actions[puzzleCur].toggles[4]==1)
					button_actions[puzzleCur].toggles[4]=0;
				else
					button_actions[puzzleCur].toggles[4]=1;
				break;
			case IK_PageUp:
				if(++puzzleCur==6)
						puzzleCur=0;
				btnToggles[puzzleCur].TurnOn();
				break;
			case IK_PageDown:
				if(--puzzleCur==-1)
						puzzleCur=5;
				btnToggles[puzzleCur].TurnOn();
				break;
			case IK_0:
			case IK_NumPad0:
				log(PuzzleDebugString());
				break;

			default:
				bKeyHandled = False;
				break;
		}

		alignMessage.SetText(PuzzleDebugString());

		if (!bKeyHandled)
			return Super.VirtualKeyPressed(key, bRepeat);
		else
			return bKeyHandled;
		
	}

	switch(key)
	{
		//reserve keys that are checked in Tick
		case IK_Up:
			alignUp.PressButton();
			break;
		case IK_Down:
			alignDown.PressButton();
			break;
		case IK_Left:
			alignLeft.PressButton();
			break;
		case IK_Right:
			alignRight.PressButton();
			break;
		case IK_NumPad0:
			alignSize.PressButton();
			break;
		case IK_PageUp:
			if(++alignCur==alignMax)
				alignCur=0;
			UpdateDebugAlignment();
		break;
		case IK_PageDown:
			if(--alignCur==-1)
				alignCur+=alignMax;
			UpdateDebugAlignment();
			break;
		case IK_NumPadPeriod:
			log("["$alignCur$"] >> X:"@alignX[alignCur]@"Y:"@alignY[alignCur]);
			break;
		case IK_Delete:
			alignX[alignCur]=0;
		case IK_Home:
			alignY[alignCur]=0;
			UpdateDebugAlignment();
			break;
		case IK_End:
			alignX[alignCur]=0;
			UpdateDebugAlignment();
			break;

		default:
			bKeyHandled = False;
			break;
	}

	if (!bKeyHandled)
		return Super.VirtualKeyPressed(key, bRepeat);
	else
		return bKeyHandled;
}

function SetNetworkTerminal(NetworkTerminal newTerm)
{
	Super.SetNetworkTerminal(newTerm);
	puzzle_computer=tnmComputerAPGPuzzle(NetworkTerminalAPGPuzzle(winTerm).CompOwner);
}

defaultproperties
{
     texProgressBarOn=Texture'TNMGUI.UI.APG_ProgressBarOn'
     texProgressBarOff=Texture'TNMGUI.UI.APG_ProgressBarOff'
     texGeneratorOn(0)=Texture'TNMGUI.UI.APG_Generator_1_1'
     texGeneratorOn(1)=Texture'TNMGUI.UI.APG_Generator_2_1'
     texGeneratorOn(2)=Texture'TNMGUI.UI.APG_Generator_3_1'
     texGeneratorOn(3)=Texture'TNMGUI.UI.APG_Generator_4_1'
     texGeneratorOn(4)=Texture'TNMGUI.UI.APG_Generator_5_1'
     texGeneratorOff(0)=Texture'TNMGUI.UI.APG_Generator_1_0'
     texGeneratorOff(1)=Texture'TNMGUI.UI.APG_Generator_2_0'
     texGeneratorOff(2)=Texture'TNMGUI.UI.APG_Generator_3_0'
     texGeneratorOff(3)=Texture'TNMGUI.UI.APG_Generator_4_0'
     texGeneratorOff(4)=Texture'TNMGUI.UI.APG_Generator_5_0'
     classClient=Class'TNMGUI.tnmMenuUIClientWindowNoStyle'
     Title="Generator Control Panel"
     ClientWidth=640
     ClientHeight=480
     clientTextures(0)=Texture'TNMGUI.UI.APG_Background1'
     clientTextures(1)=Texture'TNMGUI.UI.APG_Background2'
     clientTextures(2)=Texture'TNMGUI.UI.APG_Background3'
     clientTextures(3)=Texture'TNMGUI.UI.APG_Background4'
     clientTextures(4)=Texture'TNMGUI.UI.APG_Background5'
     clientTextures(5)=Texture'TNMGUI.UI.APG_Background6'
     textureRows=2
     textureCols=3
     bUsesStatusWindow=False
     ComputerNodeFunctionLabel="Login"
}
